<?php

namespace App\Models;

use App\Constants\Status;
use App\Traits\GlobalStatus;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;

class StoryComment extends Model
{
    use GlobalStatus;

    // blog
    public function story()
    {
        return $this->belongsTo(SuccessStory::class, 'success_story_id');
    }

    public function scopePublished($query) {
        return $query->where('status', Status::PUBLISHED);
    }
    public function scopeUnpublish($query) {
        return $query->where('status', Status::UNPUBLISH);
    }


    public function statusBadge(): Attribute
    {
        return new Attribute(function(){
            $html = '';
            if ($this->status == Status::STORY_APPROVED) {
                $html = '<span class="badge badge--success">' . trans("Approved") . '</span>';
            } elseif ($this->status == Status::STORY_DECLINED) {
                $html = '<span class="badge badge--danger">' . trans("Declined") . '</span>';
            }
            return $html;
        });
    }


}
