@extends($activeTemplate . 'layouts.frontend')
@section('content')
    @php
        $data = getContent('campaign.content', true);
        session()->forget('DONATION');
    @endphp
    <!-- Urgent Fundrised -->
    <section class="pt-90 pb-120">
        <div class="container-fluid custom-container">
            <div class="row m-0">
                <div class="col-xl-3 ">
                    <aside class="category-sidebar">
                        <div class="widget d-xl-none filter-top">
                            <div class="d-flex justify-content-between align-items-center">
                                <h5 class="title border-0 pb-0 mb-0">@lang('Filter')</h5>
                                <div class="close-sidebar"><i class="las la-times"></i></div>
                            </div>
                        </div>
                        <!--Name Filter-->
                        <div class="widget p-0">
                            <h5 class="widget-title">@lang('Filter By Campaign Title')</h5>
                            <form class="no-submit-loader">
                                <div class="widget-body">
                                    <div class="input-group">
                                        <input type="text" class="form-control" name="search"
                                            placeholder="@lang('Enter Title..')" value="{{ request()->search }}" />
                                        <button class="input-group-text name-search" type="button"> <i
                                                class="la la-search"></i></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <!--Campaign RadioBox Filter-->
                        <div class="widget p-0">
                            <h5 class="widget-title">@lang('Filter By Criteria')</h5>
                            <div class="widget-body">
                                <div class="widget-input-group">
                                    <input class="check_size_xs" checked id="criteria1" name="criteria" type="radio"
                                        value="">
                                    <label class="form-check-label" for="criteria1">@lang('All')</label>
                                </div>
                                <div class="widget-input-group">
                                    <input class="check_size_xs" id="criteria2" name="criteria" type="radio"
                                        value="urgent">
                                    <label class="form-check-label" for="criteria2">@lang('Urgent Campaigns')</label>
                                </div>

                                <div class="widget-input-group">
                                    <input class="check_size_xs" id="criteria3" name="criteria" type="radio"
                                        value="featured">
                                    <label class="form-check-label" for="criteria3">@lang('Featured Campaigns')</label>
                                </div>

                                <div class="widget-input-group">
                                    <input class="check_size_xs" id="criteria4" name="criteria" type="radio"
                                        value="top">
                                    <label class="form-check-label" for="criteria4">@lang('Top Campaigns')</label>
                                </div>
                            </div>
                        </div>
                        <!--Category Filter-->
                        <div class="widget p-0">
                            <h5 class="widget-title">@lang('Filter By Category')</h5>
                            <div class="widget-body">
                                <ul class="filter-category">
                                    @php
                                        $categoryCount = $categories->count();
                                    @endphp
                                    @if ($categoryCount > 0)
                                        <li class="mb-3 campaign-category active" data-id="0">
                                            <span class="icon"><i class="fa-solid fa-angles-right"></i></span>
                                            <span class="text">@lang('All')</span>
                                        </li>
                                    @endif
                                    @forelse ($categories as $category)
                                        <li class="mb-3 campaign-category {{ request()->category == $category->slug ? 'active' : '' }}"
                                            data-id="{{ $category->id }}">
                                            <span class="icon"><i class="fa-solid fa-angles-right"></i></span>
                                            <span class="text">{{ __($category->name) }}</span>
                                        </li>
                                    @empty
                                        <div class="text-center py-3">
                                            @include($activeTemplate . 'partials.empty', [
                                                'message' => 'Campaigns not found!',
                                            ])
                                        </div>
                                    @endforelse
                                </ul>
                            </div>
                        </div>
                        <!--Date Filter-->
                        <div class="widget p-0">
                            <h5 class="widget-title text-white p-2 rounded-top">@lang('Filter by date')</h5>
                            <div class="widget-body p-3 border rounded-bottom position-relative bg-light">
                                <div class="input-group">
                                    <input class="form-control datepicker bg-white border-0" type="text" name="date"
                                        placeholder="@lang('Select Date')" autocomplete="off">
                                    <span class="input-group-text bg-white border-0">
                                        <i class="fa-solid fa-calendar-days"></i>
                                    </span>
                                    <button type="button" class="btn btn-danger clear-btn clearDate">
                                        <i class="las la-trash-alt"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </aside>
                </div>
                <div class="col-xl-9">
                    <div class="filter_in_btn d-xl-none mb-3 d-flex justify-content-end">
                        <a href="javascript:void(0)"><i class="las la-filter"></i></a>
                    </div>

                    <div class="row filter_tab_menu_wrapper main-campaign-view gy-4">
                        @include($activeTemplate . 'campaign.campaign')
                    </div>
                    @if ($campaigns->hasPages())
                        @php echo paginateLinks($campaigns) @endphp
                    @endif
                </div>
            </div>
        </div>
        <div class="spinner">
            <div class="spinner-border text-success" role="status">
                <span class="visually-hidden">@lang('Loading...')</span>
            </div>
        </div>
    </section>
    <!--section end -->

    @if ($sections->secs != null)
        @foreach (json_decode($sections->secs) as $sec)
            @include($activeTemplate . 'sections.' . $sec)
        @endforeach
    @endif
@endsection

@push('script-lib')
    <script src="{{ asset($activeTemplateTrue . 'js/flatpickr.js') }}"></script>
@endpush

@push('style-lib')
    <link href="{{ asset($activeTemplateTrue . 'css/flatpickr.min.css') }}" rel="stylesheet">
@endpush

@push('script')
    <script>
        'use strict';

        $(function() {

            let data = {};
            data.category_d = 0;
            data.checkbox = null;
            data.search = null;
            data.date = '';

            @if (request()->category)
                let categoryId = $('.campaign-category.active').data('id');
                data.category_id = categoryId;
            @endif

            const $spinner = $('.spinner');

            function showSpinner() {
                $spinner.css('display', 'flex');
            }

            function hideSpinner() {
                $spinner.css('display', 'none');
            }

            //Date-Filter and Dateficker-initialize!

            $(".datepicker").flatpickr({
                dateFormat: 'Y-m-d',
                onChange: function(selectedDates, dateStr) {
                    data.date = dateStr;
                    filterCampaigns();
                }
            });

            $('.clearDate').on('click', function() {
                $('.datepicker').val('');
                data.date = '';
                filterCampaigns();
            });

            //Search by name

            $('.name-search').on('click', function() {
                var title = $(this).siblings('input[name="search"]').val();
                data.search = title;
                filterCampaigns();
            });

            $('.name-search').closest('form').on('submit', function(e) {
                e.preventDefault();

                var title = $(this).find('input[name="search"]').val();
                data.search = title;
                filterCampaigns();
            });

            //category filter
            $('.campaign-category').each(function(index) {
                $(this).on('click', function() {
                    data.category_id = $(this).data('id');
                    filterCampaigns();
                    $('.campaign-category').not(this).removeClass('active');
                    $(this).addClass('active');
                });
            });

            // Criteria filter
            $('input[name="criteria"]').on('change', function() {
                data.criteria = $(this).val();
                $('input[name="criteria"]').prop('checked', false);
                $(this).prop('checked', true);
                if ($(this).prop('checked')) {
                    filterCampaigns();
                }
            });

            $(document).on('click', '.page-link', function(e) {
                e.preventDefault();

                let pageUrl = $(this).attr('href');
                const url = new URL(pageUrl);
                const pageValue = url.searchParams.get("page");
                data.page = pageValue;

                filterCampaigns();

            });

            function filterCampaigns() {
                showSpinner();
                $.ajax({
                    url: "{{ route('campaign.filter') }}",
                    method: 'GET',
                    data: data,
                    success: function(response) {
                        $('.main-campaign-view').html(response)
                    },
                    error: function(xhr) {
                        console.error('Error occurred:', xhr.responseText);
                    },
                    complete: function() {
                        hideSpinner();
                    }
                });
            };
        });
    </script>
@endpush

@push('style')
    <style>
        .spinner {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.8);
            z-index: 1050;
            display: none;
            justify-content: center;
            align-items: center;
        }

        .spinner .spinner-border {
            width: 3rem;
            height: 3rem;
        }

        .campaign-category.active .text {
            color: green;
        }

        .input-group .clear-btn {
            border: none;
            padding: 8px 12px;
        }

        .input-group-text {
            cursor: pointer;
        }
    </style>
@endpush
