@extends($activeTemplate . 'layouts.master')
@section('content')
    <section class="pt-90 pb-120">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-12 p-lg-5 p-md-4">
                    <div class="card custom--card">
                        <div class="card-body">
                            <form class="action-form disableSubmission" action="{{ route('user.campaign.fundrise.store') }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group select2-parent position-relative">
                                            <label class="form-label">@lang('Category')</label>
                                            <div class="input-group flex-nowrap">
                                                <span class="input-group-text"><i class="las la-layer-group"></i></span>
                                                <select class="form-control form-select select2" name="category_id" required>
                                                    @foreach ($categories as $category)
                                                        <option value="{{ $category->id }}" @selected(old('category_id') == $category->id)>
                                                            {{ __($category->name) }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label class="form-label">@lang('Goal Amount')
                                                <span data-bs-toggle="tooltip" data-bs-placement="top" type="button" title="{{ __('You will get :percentage of total raised', ['percentage' => 100 - @gs('raised_charge') . '%']) }}">
                                                    <i class="las la-info-circle"></i>
                                                </span>
                                            </label>
                                            <div class="input-group">
                                                <span class="input-group-text">{{ gs('cur_sym') }}</span>
                                                <input class="form-control" name="goal" type="number" value="{{ old('goal') }}" step="any" required>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="form-label">@lang('Title')</label>
                                    <div class="input-group">
                                        <span class="input-group-text"><i class="las la-heading"></i></span>
                                        <input class="form-control" name="title" type="text" value="{{ old('title') }}" required>
                                    </div>
                                </div>

                                <div class="form-group decide-deadline">
                                    <label class="form-label">@lang('Decide how you want to complete your campaign?')</label>
                                    <div class="form-check">
                                        <input class="form-check-input" id="after_goal" name="goal_type" type="radio" value="1">
                                        <label class="form-check-label" for="after_goal">
                                            @lang('After Goal Achieve')
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" id="after_deadline" name="goal_type" type="radio" value="2" checked>
                                        <label class="form-check-label" for="after_deadline">
                                            @lang('After Deadline')
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" id="continuous" name="goal_type" type="radio" value="3">
                                        <label class="form-check-label" for="continuous">
                                            @lang('Continuous')
                                        </label>
                                    </div>
                                </div>

                                <div class="form-group deadline-wrapper">
                                    <label class="form-label">@lang('Deadline')</label>
                                    <div class="input-group">
                                        <span class="input-group-text"><i class="far fa-clock"></i></span>
                                        <input class="datepicker-here form-control" name="deadline" data-language="en" data-position='bottom left' type="text" value="{{ old('deadline') }}" autocomplete="off">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="form-label">@lang('Description')<span class="text-danger">*</span></label>
                                    <textarea class="form-control nicEdit" name="description" rows="8">{{ old('description') }}</textarea>
                                    <small>@lang('It can be long text and describe why the campaign was created').</small>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label class="form-label">@lang('Poster Image')</label>
                                            <input class="form-control" id="inputAttachments" name="image" type="file" accept="image/*" required />
                                            <small class="text-muted"> @lang('Supported Files:')
                                                <b>@lang('.png'), @lang('.jpg'), @lang('.jpeg')</b>
                                                @lang('Image will be resized into') <b>{{ getFileSize('campaign') }}</b> @lang('px')</b>
                                            </small>
                                        </div><!-- form-group end -->
                                    </div>

                                    <div class="document-file">
                                        <div class="document-file__input">
                                            <div class="form-group">
                                                <label class="form-label">@lang('Images and Documents(.pdf)')</label>
                                                <input class="form-control mb-2" id="inputAttachments" name="attachments[]" type="file" accept=".jpg, .jpeg, .png, .pdf" required />
                                            </div><!-- form-group end -->
                                        </div>
                                        <button class="btn cmn-btn add-new" type="button">
                                            <i class="fa fa-plus"></i>
                                        </button>
                                        <div id="fileUploadsContainer"></div>
                                        <small class="text-muted"> @lang('Supported Files:')
                                            <b>@lang('.png'), @lang('.jpg'), @lang('.pdf')</b>
                                            @lang('Image will be resized into') <b>{{ getFileSize('proof') }}</b> @lang('px')</b>
                                        </small>
                                    </div>

                                    <div class="form-group">
                                        <div class="faq-wrapper">
                                            <h6 class="text-underline">@lang('Campaign FAQs'):</h6>
                                            <div class="row gx-5 gy-4">
                                                <div class="col-lg-4 col-md-6 mb-3 ">
                                                    <div class="form-group">
                                                        <label class="form-label">@lang('Question')</label>
                                                        <input class="form-control" name="question[]" type="text" required>
                                                    </div>
                                                    <div class="form-group">
                                                        <label class="form-label">@lang('Answer')</label>
                                                        <textarea class="form-control" name="answer[]" required></textarea>
                                                    </div>
                                                    <button class="btn btn--danger remove-btn w-100" type="button" disabled><i class="las la-trash"></i> @lang('Remove')</button>
                                                </div>

                                                <div class="col-lg-4 col-md-6 addFaqArea">
                                                    <div class="add-new-faq addNewFAQ mt-3">
                                                        <div class="add-new-faq-box">
                                                            <i class="las la-plus-circle"></i>
                                                            <p>@lang('Add New')</p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <button class="btn cmn-btn w-100" type="submit" type="submit">@lang('Submit')</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('style-lib')
    <link href="{{ asset($activeTemplateTrue . 'css/datepicker.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('assets/global/css/select2.min.css') }}">
@endpush
@push('script-lib')
    <script src="{{ asset('assets/global/js/nicEdit.js') }}"></script>
    <script src="{{ asset($activeTemplateTrue . 'js/datepicker.min.js') }}"></script>
    <script src="{{ asset($activeTemplateTrue . 'js/datepicker.en.js') }}"></script>
    <script src="{{ asset('assets/global/js/select2.min.js') }}"></script>
@endpush

@push('style')
    <style>
        .decide-deadline {
            margin: 0;
        }

        .select2-container--default .select2-selection--single {
            border: 0 !important;
        }
    </style>
@endpush

@push('script')
    <script>
        'use strict';

        $('.select2').select2({
            dropdownParent: $('.select2-parent')
        });


        $(".add-new").on('click', function() {
            let uploadContainer = $("#fileUploadsContainer").find('.input-group').length;
            if (uploadContainer < 4) {
                $("#fileUploadsContainer").append(` <div class="input-group mb-2">
                <input type="file" name="attachments[]" id="inputAttachments" class="form-control" accept=".jpg, .jpeg, .png, .pdf" required/>
                        <button type="button" class="input-group-text remove-btn"><i class="las la-times"></i></button>
                    </div>
                `);
            }
        })

        $(document).on('click', '.remove-btn', function() {
            $(this).closest('.input-group').remove();
        });


        //nicEdit
        $(".nicEdit").each(function(index) {
            $(this).attr("id", "nicEditor" + index);
            new nicEditor({
                fullPanel: true
            }).panelInstance('nicEditor' + index, {
                hasPanel: true
            });
        });

        (function($) {
            $(document).on('mouseover ', '.nicEdit-main,.nicEdit-panelContain', function() {
                $('.nicEdit-main').focus();
            });
        })(jQuery);

        //date-validation

        $('.datepicker-here').on('keyup keypress keydown input', function() {
            return false;
        });
        $('.datepicker-here').datepicker({
            minDate: new Date()
        })

        //Faq-added//
        $('.addNewFAQ').on('click', function() {
            $(".addFaqArea").before(`
                <div class="col-lg-4 col-md-6">
                    <div class="form-group">
                        <label class="form-label">@lang('Question')</label>
                        <input type="text" name="question[]" class="form-control">
                    </div>
                    <div class="form-group">
                        <label class="form-label">@lang('Answer')</label>
                        <textarea name="answer[]" class="form-control"></textarea>
                    </div>
                    <button type="button" class="btn btn--danger remove-btn w-100"><i class="las la-trash"></i> @lang('Remove')</button>
            </div>
                `)
            disableRemoveFaq()
        });
        $(document).on('click', '.remove-btn', function() {
            $(this).closest('div').remove();
            disableRemoveFaq()
        });

        function disableRemoveFaq() {
            if ($(document).find('.remove-btn').length == 1) {
                $(document).find('.remove-btn').attr('disabled', true);
            } else {
                $(document).find('.remove-btn').removeAttr('disabled');
            }
        }

        // deadline-wrapper
        $("[name='goal_type']").on('click', function() {
            if ($(this).val() == 2) {
                $('.deadline-wrapper').removeClass('d-none');
            } else {
                $('.deadline-wrapper').addClass('d-none');
            }
        })
        // deadline-wrapper End


        //Start tooltip//
        document.addEventListener("DOMContentLoaded", function() {
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
            var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl)
            })
            //end tooltip//
        });
    </script>
@endpush
