@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="pt-90 pb-120">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="mb-4">
                        <h3>@lang('My Referrals')</h3>
                    </div>
                    <div class="row gy-4">
                        <div class="col-md-12">
                            <div class="card custom--card mb-4">
                                <div class="card-body">
                                    <h4 class="mb-1">@lang('Refer & Enjoy the Bonus')</h4>
                                    <p class="mb-3">@lang('You\'ll get commission against your referral\'s activities. Level has been decided by the') <strong><i>{{ __(gs('site_name')) }}</i></strong> @lang('authority. If you reach the level, you\'ll get commission.')</p>
                                    <div class="form-group">
                                        <div class="copy-link">
                                            <input class="copyURL" class="form-control form--control" id="profile" name="profile" type="text" value="{{ route('home') }}?reference={{ auth()->user()->username }}" readonly="">
                                            <span class="copy" data-id="profile">
                                                <i class="las la-copy"></i> <strong class="copyText">@lang('Copy')</strong>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @if ($user->allReferrals->count() > 0 && $maxLevel > 0)
                                <div class="card custom--card">
                                    <div class="card-body">
                                        <div class="treeview-container">
                                            <ul class="treeview">
                                                <li class="items-expanded"> {{ $user->fullname }} ( {{ $user->username }} )
                                                    @include($activeTemplate . 'partials.under_tree', ['user' => $user, 'layer' => 0, 'isFirst' => true])
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('style-lib')
    <link href="{{ asset('assets/global/css/jquery.treeView.css') }}" rel="stylesheet" type="text/css">
@endpush

@push('script-lib')
    <script src="{{ asset('assets/global/js/jquery.treeView.js') }}"></script>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";
                $('.treeview').treeView();
        })(jQuery);
    </script>
@endpush
