@forelse ($campaigns as $campaign)
    <div class="{{ @$class ?? 'col-md-6' }}">
        <div class="custom--card campaign-card card h-100 card-style-two">
            <div class="card-thumb position-relative">
                <a href="{{ route('campaign.details', ['slug' => $campaign->slug]) }}">
                    <img src="{{ @getImage(getFilePath('campaign') . '/' . $campaign->image, '469x329') }}"
                        alt="img">
                </a>
                <a href="" class="badge-overlay position-absolute top-0 start-0">
                    <span class="text-white p-2 fs-14">
                        {{ $campaign->category->name }}
                    </span>
                </a>
                <div class="badge-overlay-bottom position-absolute bottom-0 end-0 bg--base rounded-4">
                    @if ($campaign->goal_type == Status::AFTER_DEADLINE)
                        <span class="fs-11 text-white p-2 py-1"> <i class="las la-calendar-check"></i>
                            {{ timeLeftUntil($campaign->deadline) }} </span>
                    @elseif($campaign->goal_type == Status::CONTINUOUS)
                        <span class="fs-11 text-white p-2 py-1"> <i class="las la-spinner"></i> @lang('Continuous')</span>
                    @else
                        <span class="fs-11 text-white p-2 py-1"> <i class="las la-trophy"></i> @lang('Achieve Goal ') </span>
                    @endif
                </div>
            </div>

            @php
                $campDonation = $campaign->donations->where('status', Status::DONATION_PAID)->sum('donation');
                $percent = percent($campDonation, $campaign);
            @endphp

            <div class="card-body">
                <h4 class="card-title"><a
                        href="{{ route('campaign.details', ['slug' => $campaign->slug]) }}">{{ __($campaign->title) }}</a>
                </h4>
                <div class="campaign-card__status">
                    <div class="campaign-card__bar">
                        <div class="campaign-card__percentage"
                            style="left: {{ getAmount(progressPercent($percent)) }}%;">
                            <span class="svg">
                                <svg xmlns="http://www.w3.org/2000/svg" width="39" height="33"
                                    viewBox="0 0 39 33" fill="none">
                                    <path
                                        d="M0 20.517C0 22.5894 2.0066 24.2771 4.47225 24.2771H13.4202L19.5009 33L25.5815 24.2785H34.5295C36.9951 24.2785 39 22.5908 39 20.5184V3.76011C39 1.68774 36.9951 0 34.5295 0H4.47225C2.0066 0 0 1.68774 0 3.76011V20.517ZM3.47764 3.76011C3.47764 3.2779 3.93321 2.87031 4.47225 2.87031H34.5312C35.0703 2.87031 35.5241 3.2779 35.5241 3.76011V20.5184C35.5241 21.0007 35.0685 21.4082 34.5312 21.4082H23.5714L19.5009 27.245L15.4303 21.4082H4.47225C3.93321 21.4082 3.47764 21.0007 3.47764 20.5184V3.76011Z"
                                        fill="#0AAE36" />
                                </svg>
                            </span>
                            <span class="text">
                                {{ getAmount(progressPercent($percent)) }}%
                            </span>
                        </div>
                        <span class="campaign-card__pipe">
                            <i class="fill"
                                style="width:{{ getAmount(progressPercent($percent)) }}%"></i></span>
                    </div>
                    <div class="campaign-card__number flex-between gap-3">
                        <div class="campaign-card__number-item">
                            <span class=" campaign-card__number-title">@lang('Goal:')</span>
                            <span
                                class="campaign-card__number-ammount">{{ showAmount($campaign->goal, decimal:false) }}</span>
                        </div>
                        <div class="campaign-card__number-item">
                            <span class="campaign-card__number-title">@lang('Raised:')</span>
                            <span
                                class="campaign-card__number-ammount">{{ showAmount($campDonation, decimal:false) }}</span>
                        </div>
                    </div>
                </div>
                <div class="card-footer flex-between">
                    <div class="campaign-card__author">
                        <span class="campaign-card__author-thumb">
                            <img src="{{ avatar(@$campaign->user->image ? getFilePath('userProfile') . '/' . @$campaign->user->image : null) }}"
                                alt="img">
                        </span>
                        <a href="{{ route('profile.index', $campaign->user->username) }}">
                            <span class="campaign-card__author-name">
                                @if ($campaign->user->enable_org)
                                    {{ __(@$campaign->user->organization->name) }}
                                @else
                                    {{ __(@$campaign->user->fullname) }}
                                @endif
                            </span>
                        </a>
                    </div>
                    <div class="campaign-card__date ">
                        <span class="icon"><i class="fa-solid fa-calendar-days"></i></span>
                        <span class="text">{{ showDateTime($campaign->created_at, 'd-m-Y') }}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
@empty
    <div class="mx-auto d-flex justify-content-center @if (request()->routeIs('home')) change-color @endif">
        <div class="card custom--card  dashboard-sidebar overflow-y-auto">
            @include($activeTemplate . 'partials.empty', ['message' => 'Campaigns not found!'])
        </div>
    </div>
@endforelse

@push('style')
    <style>
        .empty-slip-message img {
            width: 75px !important;
            margin-bottom: 0.875rem;
        }

        .card-thumb {
            position: relative;
        }

        .badge-overlay {
            background: #28a745;
            color: white;
            font-size: 14px;
            font-weight: bold;
            padding: 5px 10px;
            border-radius: 0 0 8px 0;
            text-transform: uppercase;
        }

        .badge-overlay-bottom {
            background: transparent;
            margin: 10px;
            z-index: 1;
        }

        .badge-overlay-bottom .btn {
            font-size: 12px;
            padding: 5px 10px;
            background-color: #28a745;
            color: white;
            border: none;
            border-radius: 20px;
            text-transform: capitalize;
        }

        .badge-overlay span {
            display: inline-block;
        }
    </style>
@endpush
