@php
    $donorVisibility =  getContent('campaign_details.content',true);
    $donor = $campaign->donations->where('status', Status::DONATION_PAID);
    $donation = $donor->sum('donation');
    $percent = percent($donation, $campaign);
@endphp

@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <main class="campaign-details-page">
        <section class="campaign-details my-120">
            <div class="container">
                <div class="row gy-4">
                    <div class="col-xl-8">
                        <div class="campaign-details__content">
                            <div class="campaign-details__thumb position-relative">
                                <img class="img-fluid"
                                    src="{{ getImage(getFilePath('campaign') . '/' . $campaign->image, '856x550') }}"
                                    alt="campaign-thumb">
                                <!-- Favorite button -->
                                @php
                                    $isFavorite = auth()->check() && in_array($campaign->id, $myFavorites ?? []);
                                    $favoriteClass = $isFavorite ? 'active' : '';
                                    $favoriteTitle = $isFavorite ? __('Remove Favorite') : __('Make Favorite');
                                @endphp
                                <span class="favorite-btn position-absolute favoriteBtn {{ $favoriteClass }}"
                                    data-id="{{ $campaign->id }}" title="{{ $favoriteTitle }}?">
                                    <i class="fa-regular fa-heart"></i>
                                </span>
                            </div>
                            <div class="campaign-details__body">
                                <div class="campaign-details__nav">
                                    <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                        <li class="active-effect"></li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link active" id="pills-description-tab" data-bs-toggle="pill"
                                                data-bs-target="#pills-description" type="button" role="tab"
                                                aria-controls="pills-description" aria-selected="true">
                                                <span class="icon"><i class="las la-clipboard-list"></i></span>
                                                <span class="text">@lang('Description')</span>
                                            </button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link" id="pills-gallery-tab" data-bs-toggle="pill"
                                                data-bs-target="#pills-gallery" type="button" role="tab"
                                                aria-controls="pills-gallery" aria-selected="false">
                                                <span class="icon"><i class="las la-image"></i></span>
                                                <span class="text">@lang('Gallery')</span>
                                            </button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link" id="pills-document-tab" data-bs-toggle="pill"
                                                data-bs-target="#pills-document" type="button" role="tab"
                                                aria-controls="pills-document" aria-selected="false">
                                                <span class="icon"><i class="las la-file-alt"></i></span>
                                                <span class="text">@lang('Document')</span>
                                            </button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link" id="pills-faq-tab" data-bs-toggle="pill"
                                                data-bs-target="#pills-faq" type="button" role="tab"
                                                aria-controls="pills-faq" aria-selected="false">
                                                <span class="icon"><i class="las la-question-circle"></i></span>
                                                <span class="text">@lang('FAQ')</span>
                                            </button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link" id="pills-review-tab" data-bs-toggle="pill"
                                                data-bs-target="#pills-review" type="button" role="tab"
                                                aria-controls="pills-review" aria-selected="false">
                                                <span class="icon"><i class="las la-user-tie"></i></span>
                                                <span class="text">@lang('Review')</span>
                                            </button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link" id="pills-update-tab" data-bs-toggle="pill"
                                                data-bs-target="#pills-update" type="button" role="tab"
                                                aria-controls="pills-update" aria-selected="false">
                                                <span class="icon"><i class="las la-redo-alt"></i></span>
                                                <span class="text">@lang('Update')</span>
                                            </button>
                                        </li>
                                    </ul>
                                </div>
                                <div class="tab-content" id="pills-tabContent">
                                    @include('Template::campaign.details.description')
                                    @include('Template::campaign.details.gallery')
                                    @include('Template::campaign.details.document')
                                    @include('Template::campaign.details.faq')
                                    @include('Template::campaign.details.review')
                                    @include('Template::campaign.details.update')
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4">
                        <div class="row gy-4">
                            <div class="col-12">
                                <div class="sidebar-card campaign-card">
                                    <div class="card-body">
                                        @if ($campaign->goal_type == Status::AFTER_DEADLINE)
                                            <div class="campaign-card__continuos">
                                                <span class="days-left" data-deadline={{ $campaign->deadline }}>
                                                    <span class="day"></span>
                                                    <span class="hour"></span>
                                                    <span class="minute"></span>
                                                    <span class="sec"></span>
                                                </span>
                                            </div>
                                        @elseif($campaign->goal_type == Status::CONTINUOUS)
                                            <div class="campaign-card__continuos">
                                                <span class="icon"><i class="fa-solid fa-spinner"></i></span><span
                                                    class="text">@lang('Continuous')</span>
                                            </div>
                                        @else
                                            <div class="campaign-card__continuos">
                                                <span class="icon"><i class="las la-trophy"></i></span><span
                                                    class="text">@lang('Achieve Goal')</span>
                                            </div>
                                        @endif
                                        <h4 class="card-title">{{ __($campaign->title) }}</h4>
                                        <div class="campaign-card__status">
                                            <div class="campaign-card__bar">
                                                <div class="campaign-card__percentage"
                                                    style="left: {{ progressPercent($percent) }}%;">
                                                    <span class="svg">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="39"
                                                            height="33" viewBox="0 0 39 33" fill="none">
                                                            <path
                                                                d="M0 20.517C0 22.5894 2.0066 24.2771 4.47225 24.2771H13.4202L19.5009 33L25.5815 24.2785H34.5295C36.9951 24.2785 39 22.5908 39 20.5184V3.76011C39 1.68774 36.9951 0 34.5295 0H4.47225C2.0066 0 0 1.68774 0 3.76011V20.517ZM3.47764 3.76011C3.47764 3.2779 3.93321 2.87031 4.47225 2.87031H34.5312C35.0703 2.87031 35.5241 3.2779 35.5241 3.76011V20.5184C35.5241 21.0007 35.0685 21.4082 34.5312 21.4082H23.5714L19.5009 27.245L15.4303 21.4082H4.47225C3.93321 21.4082 3.47764 21.0007 3.47764 20.5184V3.76011Z"
                                                                fill="#0AAE36" />
                                                        </svg>
                                                    </span>
                                                    <span
                                                        class="text">{{ progressPercent($percent) }}%</span>
                                                </div>
                                                <span class="campaign-card__pipe"><i class="fill"
                                                        style="width:{{ progressPercent($percent) }}%"></i></span>
                                            </div>
                                            <div class="campaign-card__number flex-between gap-3">
                                                <div class="campaign-card__number-item">
                                                    <span class=" campaign-card__number-title">@lang('Goal:')</span>
                                                    <span
                                                        class="campaign-card__number-ammount">{{ showAmount($campaign->goal) }}</span>
                                                </div>
                                                <div class="campaign-card__number-item">
                                                    <span class="campaign-card__number-title">@lang('Raised:')</span>
                                                    <span
                                                        class="campaign-card__number-ammount">{{ showAmount($donation) }}</span>
                                                </div>
                                            </div>
                                            <div class="author-info flex-between pt-0">
                                                <div class="campaign-card__author">
                                                    <span class="campaign-card__author-thumb">
                                                        @if ($campaign->user->enable_org)
                                                            <img src="{{ avatar(@$campaign->user->organization->image ? getFilePath('orgProfile') . '/' . @$campaign->user->organization->image : null) }}"
                                                                alt="org-cover-avatar">
                                                        @else
                                                            <img src="{{ avatar(@$campaign->user->image ? getFilePath('userProfile') . '/' . @$campaign->user->image : null) }}"
                                                                alt="user-avatar">
                                                        @endif
                                                    </span>
                                                    <a href="{{ route('profile.index', $campaign->user->username) }}">
                                                        <span class="campaign-card__author-name">
                                                            @if ($campaign->user->enable_org)
                                                                {{ __(@$campaign->user->Organization?->name) }}
                                                            @else
                                                                {{ __(@$campaign->user->fullname) }}
                                                            @endif
                                                        </span>
                                                    </a>
                                                </div>
                                                <div class="campaign-card__date ">
                                                    <span class="icon"><i class="fa-solid fa-calendar-days"></i></span>
                                                    <span class="text">{{ showDateTime($campaign->created_at) }}</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="card-footer flex-between">
                                        <div class="target-amount">
                                            <p class="title flex-align"><span class="icon me-1"><i
                                                        class="icon-target-5-1"></i></span>@lang('Also To Go')</p>
                                            <span class="ammount text--base">
                                                @if ($campaign->goal > $donation)
                                                    {{ showAmount($campaign->goal - $donation) }}
                                                @else
                                                    + {{ showAmount($donation - $campaign->goal) }}
                                                @endif
                                            </span>
                                        </div>
                                        <div class="not-complete-amount">
                                            <p class="title"><span class="icon me-1"><i
                                                        class="icon-Clock"></i></span>@lang('Not Yet Completed')</p>
                                            @php
                                                $today = new DateTime();
                                                $deadline = new DateTime($campaign->deadline); // Convert to DateTime object
                                                $interval = $today->diff($deadline);
                                            @endphp
                                            <span class="ammount text--base">{{ $interval->days }}
                                                @lang('days to go')</span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            @include('Template::campaign.details.form')

                            <div class="col-12">
                                <div class="sidebar-card share-card">
                                    <h5 class="sidebar-card__title mb-0">@lang('Share Campaign')</h5>
                                    <div class="sidebar-card__content">
                                        <div class="form-group">
                                            <div class="input-group input--group">
                                                <input type="text" class="form-control form--control copyURL"
                                                    id="profile" name="profile" value="{{ url()->current() }}"
                                                    readonly>
                                                <span class="input-group-text copy" data-id="profile"><i
                                                        class="las la-copy"></i></span>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <button class="btn btn-outline--base w-100" id="copyButton"
                                                data-profile="{{ url()->current() }}"
                                                data-url="{{ route('campaign.widget', $campaign->id) }}"
                                                type="button">@lang('Copy Widget for WebPage')&nbsp;<i class="far fa-copy"></i></span></button>
                                        </div>

                                        <div class="form-group">
                                            <textarea id="embedCode" class="form--control" readonly><iframe src="{{ url()->current() }}" width="768" height="250"></iframe>
                                        </textarea>
                                        </div>
                                        <div class="form-group">
                                            <button class="btn btn-outline--base w-100 copyEmbed"
                                                data-embed="">@lang('Copy Embed Code')</button>
                                        </div>
                                        <div class="share-card__social">
                                            <a href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode(url()->current()) }}"
                                                target="_blank" class="share-card__social-item"><i
                                                    class="fa-brands fa-facebook-f"></i></a>
                                            <a href="skype:?chat&topic={{ urlencode(@$campaign->title) }}&message={{ urlencode(url()->current()) }}"
                                                target="_blank" class="share-card__social-item"><i
                                                    class="fa-brands fa-skype"></i></a>
                                            <a href="https://twitter.com/intent/tweet?text={{ __(@$campaign->title) }}&amp;url={{ urlencode(url()->current()) }}"
                                                target="_blank" class="share-card__social-item"><i
                                                    class="fa-brands fa-twitter"></i></a>
                                            <a href="http://www.linkedin.com/shareArticle?mini=true&amp;url={{ urlencode(url()->current()) }}"
                                                target="_blank" class="share-card__social-item"><i
                                                    class="fa-brands fa-linkedin-in"></i></a>
                                            <a href="https://t.me/share/url?url={{ urlencode(url()->current()) }}&text={{ urlencode($campaign->title) }}"
                                                target="_blank" class="share-card__social-item"><i
                                                    class="fab fa-telegram"></i></a>
                                            <a href="https://pinterest.com/pin/create/button/?url={{ urlencode(url()->current()) }}&media={{ urlencode(getImage(getFilePath('campaign') . '/' . $campaign->image, getFileSize('campaign'))) }}&description={{ urlencode(strLimit($campaign->description, 40)) }}"
                                                target="_blank" class="share-card__social-item"><i
                                                    class="fab fa-pinterest"></i></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @if ($campaign->donor_visibility)
                            <div class="col-12">
                                <div class="sidebar-card milestone-card">
                                    <h5 class="sidebar-card__title mb-0">{{ __(@$donorVisibility->data_values->title) }}</h5>
                                    <div class="sidebar-card__content">
                                        <p class="text--secondary fw-semibold">{{ __(@$donorVisibility->data_values->sub_title) }}</p>
                                        <ul class="donor-small-list m-2">
                                            @php
                                                $allDonors = $donor;
                                            @endphp
                                            @forelse($allDonors->take(5) as $donor)
                                                <li class="list-group-item d-flex align-items-center mb-3">
                                                    <div class="me-3 default-user">
                                                        <img src="{{ @$donor->user->image ? getImage(getFilePath('userProfile') . '/' . $donor->user->image, getFileSize('userProfile')) : asset('assets/images/user/avatar.png') }}"
                                                            alt="img">
                                                    </div>
                                                    <div>
                                                        <h6 class="mb-1">{{ $donor->fullname }}</h6>
                                                        <p class="mb-0">@lang('Amount'):
                                                            {{ showAmount($donor->donation) }}</p>
                                                    </div>
                                                </li>
                                            @empty
                                                <div class="text-center py-10">
                                                    @include($activeTemplate . 'partials.empty', [
                                                        'message' => 'No donations raised yet!',
                                                    ])
                                                </div>
                                            @endforelse

                                            @if ($allDonors->count() > 5)
                                                <li class="single mt-4">
                                                    <button class="btn btn-outline--base w-100" id="donarModal"
                                                        data-bs-toggle="modal" data-bs-target="#modelId"
                                                        type="button">@lang('View All')</button>
                                                </li>
                                            @endif
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>
    @if ($campaign->donor_visibility)
        <div class="modal fade" id="modelId" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true"
            tabindex="-1">
            <div class="modal-dialog modal-dialog-scrollable" role="document">
                <div class="modal-content custom--modal">
                    <div class="modal-header">
                        <h5 class="modal-title">@lang('All Donors')</h5>
                        <button class="btn-close" data-bs-dismiss="modal" type="button" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="pb-5">
                            <ul class="donor-small-list">
                                @foreach ($allDonors as $donor)
                                    <li class="list-group-item d-flex align-items-center mb-3">
                                        <div class="me-3 default-user">
                                            <img src="{{ @$donor->user->image ? getImage(getFilePath('userProfile') . '/' . $donor->user->image, getFileSize('userProfile')) : asset('assets/images/user/avatar.png') }}"
                                                alt="img">
                                        </div>
                                        <div>
                                            <h6 class="mb-1">{{ $donor->fullname }}</h6>
                                            <p class="mb-0">@lang('Amount'):
                                                {{ showAmount($donor->donation) }}</p>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif
@endsection

@push('style')
    <style>
        .star-rating {
            display: flex;
            gap: 5px;
            cursor: pointer;
        }

        .star-rating .star i {
            font-size: 1.5rem;
            color: #ccc;
            transition: color 0.3s ease;
        }

        .star-rating .star.selected i,
        .star-rating .star.hover i {
            color: #f1c40f;
        }

        .campaign-details__thumb {
            position: relative;
        }

        .favorite-btn {
            position: absolute;
            bottom: 10px;
            right: 10px;
            background-color: white;
            border: none;
            border-radius: 50%;
            box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: background-color 0.3s ease, color 0.3s ease;
        }

        .favorite-btn.active {
            background-color: #dc3545;
        }

        .favorite-btn.active i {
            color: white;
        }

        .favorite-btn i {
            font-size: 18px;
            color: #dc3545;
            transition: transform 0.3s ease;
        }

        .favorite-btn:hover {
            background-color: #dc3545;
        }

        .favorite-btn:hover i {
            color: white;
            transform: scale(1.2);
        }

        .days-left>span {
            display: inline-flex;
            align-items: center;
            justify-content: center;
        }
    </style>
@endpush

@push('script')
    <script>
        'use strict';

        (function($) {

            $('.copyEmbed').on('click', function() {
                var copyText = document.getElementById("embedCode");
                copyText.select();
                copyText.setSelectionRange(0, 99999)
                document.execCommand("copy");
            })

            $('.checkdon').on('change', function() {
                var status = this.checked;
                if (status) {
                    $('.checktoggle').prop("disabled", true)
                    $('input[name=name]').val('');
                    $('input[name=email]').val('');
                    $('input[name=mobile]').val('');
                    $('input[name=country]').val('');
                } else {
                    @if (@$user)
                        let user = @json($user);
                        $('input[name=name]').val(user.firstname + ' ' + user.lastname);
                        $('input[name=email]').val(user.email);
                        $('input[name=mobile]').val(user.mobile);
                        $('input[name=country]').val(user.address.country);
                    @endif
                    $('.checktoggle').prop("disabled", false)
                }
            })

            $(".progressbar").each(function() {
                $(this).find(".bar").animate({
                    "width": $(this).attr("data-perc")
                }, 3000);
                $(this).find(".label").animate({
                    "left": $(this).attr("data-perc")
                }, 3000);
            });

            //donation-checkbox
            $(".donation-radio-check").on('click', function(e) {
                $(".donation-radio-check").attr('checked', false);
                $(this).prop('checked', true);
                $("[name=amount]").val($(this).val())
            });

            $(".donateAmount").on('click', function(e) {
                $(".donation-radio-check").prop('checked', false);
                $(".custom-donation").prop('checked', true);
                $(this).val("");
            });

            $(".custom-donation").on('click', function(e) {
                $("[name=amount]").focus();
                $("[name=amount]").val();
            });

            //donor list
            $('#donarModal').click(function() {
                $('#modelId').modal('show')
            })

            $(document).ready(function() {

                //favourite-start//
                $('.favoriteBtn').on('click', function() {
                    var isAuthenticated = @json(auth()->check());

                    if (!isAuthenticated) {
                        notify('error', 'Login required for making favorite campaign!');
                        return 0;
                    }
                    var $this = $(this);
                    var id = $(this).data('id');
                    $.ajax({
                        type: "GET",
                        url: "{{ route('user.favorite.add') }}",
                        data: {
                            id: id
                        },
                        success: function(response) {
                            if (response.action == 'add') {
                                $this.addClass('active');
                                notify('success', response.notification);
                            } else {
                                $this.removeClass('active');
                                notify('success', response.notification);
                            }
                        }
                    });
                });
                //favorite-end//
            });

        })(jQuery);
    </script>
    <script>
        "use strict";

        document.addEventListener('DOMContentLoaded', function() {
            const stars = document.querySelectorAll('.star-rating .star');
            const ratingInput = document.getElementById('ratingInput');

            let currentRating = 0;

            stars.forEach((star) => {
                star.addEventListener('mouseover', function() {
                    resetStars();
                    highlightStars(star.dataset.value);
                });

                star.addEventListener('mouseout', function() {
                    resetStars();
                    highlightStars(currentRating);
                });

                star.addEventListener('click', function() {
                    currentRating = star.dataset.value;
                    ratingInput.value = currentRating;
                    highlightStars(currentRating);
                });
            });

            function resetStars() {
                stars.forEach((s) => s.classList.remove('selected', 'hover'));
            }

            function highlightStars(value) {
                stars.forEach((s) => {
                    if (s.dataset.value <= value) {
                        s.classList.add('selected');
                    }
                });
            }
        });
    </script>
    <script>
        "use strict";
        var x = setInterval(function() {
            var deadline = $('.days-left').each(function(item) {

                var countDownDate = new Date($(this).data('deadline')).getTime();
                var now = new Date().getTime();
                var distance = countDownDate - now;
                var days = Math.floor(distance / (1000 * 60 * 60 * 24));
                var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                var seconds = Math.floor((distance % (1000 * 60)) / 1000);
                $(this).children('.day').text(days + 'D');
                $(this).children('.hour').text(hours + 'H');
                $(this).children('.minute').text(minutes + 'M');
                $(this).children('.sec').text(seconds + 'S');

                if (distance < 0) {
                    clearInterval(x);
                    document.getElementById("demo").innerHTML = "EXPIRED";
                }

            });

        }, 1000);
    </script>
    <script>
        "use strict";
        window.addEventListener('load', function() {
            const activeTab = localStorage.getItem('activeTab');
            if (activeTab) {
                const targetTab = document.querySelector(activeTab);
                if (targetTab) {
                    targetTab.click();
                }
            }
        });
        const tabButtons = document.querySelectorAll('.nav-link');
        tabButtons.forEach(function(tabButton) {
            tabButton.addEventListener('click', function() {
                localStorage.setItem('activeTab', '#' + tabButton.id);
            });
        });
    </script>
    <script>
        "use strict";
        $(document).on('click', '.load-more-btn', function() {
            let button = $(this);
            let page = button.data('page');
            let campaignId = button.data('campaign-id');

            $.ajax({
                url: "{{ route('campaign.comments.loadMore') }}",
                type: "GET",
                data: {
                    campaign_id: campaignId,
                    page: page
                },
                beforeSend: function() {
                    button.text('@lang('Loading...')').prop('disabled', true);
                },
                success: function(response) {
                    if (response.html) {
                        $('#commentList').append(response.html);
                        if (response.hasMore) {
                            button.data('page', page + 1).text('@lang('Load More')').prop('disabled',
                                false);
                        } else {
                            button.remove();
                        }
                    }
                },
                error: function() {
                    button.text('@lang('Load More')').prop('disabled', false);
                    alert('@lang('Something went wrong. Please try again.')');
                }
            });
        });

        //Copy-widget-Start-Here//
        $("#copyButton").click(function() {
                var e = $("#copyButton").data("url"),
                    t = $("#copyButton").data("profile"),
                    n = "{{ gs('site_name') }}",
                    o = 'fetch("' + e +
                    '").then(response=>response.json()).then(data=>{let progressBar=\'<div style="background-color: rgb(0 0 0 / 10%);border-radius: 5px;height: 12px;max-width: 380px;margin: auto;"><div style="background-color: rgb(38 188 106);color: white;text-align: right;font-size: 12px;border-radius: inherit;padding: 0;line-height: 1.2; font-weight: 500; height: 100%; display: flex; align-items: center; justify-content: center; position: relative; width: \'+data.progress_percent+\'%;">...</div></div>\', poweredBy="<p>Powered By: ' +
                    n +
                    '</p>", sdon="&hearts; Send Donation to "+data.profile_name+"\'s Campaign", cimg=\'<img style="height: 100%; width: 100%; object-fit: cover;" src="\'+data.user_image+\'" alt="campaign Image"/>\', title=\'<h3 style="line-height: 1.2; font-size: 18px; font-weight: 600; margin-bottom: 6px;">\'+data.title+\'</h3>\', cdes=data.description, camWidgets=document.getElementsByClassName("campaign-widget"); for(let i=0; i<camWidgets.length; i++){ camWidgets[i].innerHTML=\'<div style="height: 100px; width: 136px; border-radius: 5px; margin: 0 auto 8px; padding: 4px; border: 1px solid rgb(0 0 0 / 10%); overflow: hidden;">\'+cimg+\'</div>\'+title+\'<p style="line-height: 1.4; font-size: 14px; max-width: 400px; margin: 0 auto 27px; color: rgb(0 0 0 / 50%); display: -webkit-box; -webkit-line-clamp: 2; overflow: hidden; -webkit-box-orient: vertical;">\'+cdes+\'</p>\'+progressBar+\'<button style="margin-top: 12px; background: white; color: #21c927; font-size: 12px; padding: 8px 16px; line-height: 1; border-radius: 4px; font-weight: 500; border: 1px solid rgb(0 0 0 / 10%);" class="cam-widget-btn" type="button">\'+sdon+\'</button><div style="font-size: 12px; margin-top: 6px; color: #696969; text-decoration: underline;">\'+poweredBy+\'</div>\'; } }).catch(function(error){ console.warn("Something went wrong.", error); let camWidgets=document.getElementsByClassName("campaign-widget"); for(let i=0; i<camWidgets.length; i++){ camWidgets[i].innerText="Failed to load widget."; } });',
                    i =
                    '<style>.campaign-widget-percent::after {content: ""; border: 4px solid #21c927; border-top-color: transparent; border-left-color: transparent; position: absolute; top: calc(100% - 8px); right: 4px; transform: rotate(45deg);}.campaign-widget:hover .cam-widget-btn {background-color: #21c927 ! important; color: white !important;}</style>',
                    a = '<a href="' + t +
                    '" class="campaign-widget" style="text-align: center; display: block; max-width: 450px; margin: 50px auto; padding: 16px; border-radius: 5px; background-color: #ffff; box-shadow: 0px 5px 30px rgb(0 0 0 / 10%)"  target="_blank"></a>',
                    r = i + a + ' <script> ' + o + ' <\/script>',
                    l = $("<textarea>").val(r).appendTo("body").select();
                try {
                    var c = document.execCommand("copy"),
                        s = c ? "successful" : "unsuccessful";
                    notify('success', "Script copied " + s)
                } catch (e) {
                    console.error("Oops, unable to copy", e)
                }
                l.remove()
            });
            //Copy-widget-end-Here//
    </script>
@endpush
