@if (@auth()->user()->id != $campaign->user_id)
    <form method="POST" action="{{ route('campaign.donation.process', [$campaign->slug, $campaign->id]) }}">
        @csrf
        <div class="col-12">
            <div class="sidebar-card donation-card">
                <h5 class="sidebar-card__title mb-0">@lang('Donation Information')</h5>
                <div class="sidebar-card__content">
                    <div class="form-group">
                        <div class="input-group">
                            <span class="input-group-text align-items-center">{{ __(@gs('cur_sym')) }}</span>
                            <input type="number" class="form--control donateAmount" name="amount" min="1"
                                value="0" step="0.01" placeholder="@lang('Enter your amount')" required style="flex: 1;">
                        </div>
                    </div>
                    <div class="form-group sidebar-card__radio mb-3">
                        <div class="form-check form--radio">
                            <input class="form-check-input donation-radio-check" id="customRadioInline1" type="radio"
                                name="customRadioInline1" value="100">
                            <label class="form-check-label" for="customRadioInline1">
                                {{ gs('cur_sym') }}@lang('100')
                            </label>
                        </div>
                        <div class="form-check form--radio">
                            <input class="form-check-input donation-radio-check" id="customRadioInline2" type="radio"
                                name="customRadioInline1" value="200">
                            <label class="form-check-label" for="customRadioInline2">
                                {{ gs('cur_sym') }}@lang('200')
                            </label>
                        </div>
                        <div class="form-check form--radio">
                            <input class="form-check-input donation-radio-check" id="customRadioInline3" type="radio"
                                name="customRadioInline1" value="300">
                            <label class="form-check-label" for="customRadioInline3">
                                {{ gs('cur_sym') }}@lang('300')
                            </label>
                        </div>
                        <div class="form-check form--radio">
                            <input class="form-check-input donation-radio-check custom-donation" id="flexRadioDefault4"
                                type="radio" name="customRadioInline1">
                            <label class="form-check-label" for="flexRadioDefault4">
                                @lang('Custom')
                            </label>
                        </div>
                    </div>
                    @if (gs('anonymous_donation') == App\Constants\Status::YES)
                        <div class="form-group">
                            <div class="form-check form--check">
                                <input class="form-check-input checkdon" type="checkbox" name="anonymous" value="1"
                                    id="checkdon">
                                <label class="form-check-label" for="checkdon">@lang('Donate Anonymously')</label>
                            </div>
                        </div>
                    @endif
                    @php
                        $user = auth()->user();
                    @endphp

                    <div class="form-group">
                        <label class="form--label">@lang('Full Name')</label>
                        <input type="text" class="form--control checktoggle" name="name"
                            value="{{ old('name', @$user->fullname) }}" required>
                    </div>
                    <div class="form-group">
                        <label class="form--label">@lang('Email')</label>
                        <input type="email" class="form--control checktoggle" name="email"
                            value="{{ old('email', @$user->email) }}" required>
                    </div>
                    <div class="form-group">
                        <label class="form--label">@lang('Mobile')</label>
                        <input type="tel" class="form--control checktoggle" name="mobile"
                            value="{{ old('mobile', @$user->mobile) }}" required>
                    </div>
                    <div class="form-group">
                        <label class="form--label">@lang('Country')</label>
                        <input type="text" class="form--control checktoggle" name="country"
                            value="{{ old('country', @$user->country_name) }}" required>
                    </div>
                    <div class="form-group mb-0">
                        <input name="campaign_id" type="hidden" value="{{ $campaign->id }}">
                        <button class="btn btn--base w-100 mt-3" type="submit"
                            @if (@auth()->user()->id == $campaign->user_id) disabled @endif>@lang('Make your donation')</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
@endif
