<div class="tab-pane fade" id="pills-review" role="tabpanel" aria-labelledby="pills-review-tab" tabindex="0">

    <div class="campaign-review">
        @php
            $userHasReviewed = $campaign->comments
                ->where('user_id', auth()->id())
                ->whereIn('status', [Status::PUBLISHED, Status::PENDING])
                ->isNotEmpty();
        @endphp
        @if (auth()->user() && $campaign->user_id != auth()->id() && !$userHasReviewed)
            <div class="campaign-review__input mb-60">
                <h5 class="title">@lang('Leave a Review')</h5>
                <form action="{{ route('campaign.comment') }}" method="POST">
                    @csrf
                    <!-- Star Rating -->
                    <div class="form-group">
                        <label class="post-review form--label">@lang('Post your Review')</label>
                        <div class="star-rating" id="starRating">
                            <span class="star" data-value="1"><i class="fa fa-star"></i></span>
                            <span class="star" data-value="2"><i class="fa fa-star"></i></span>
                            <span class="star" data-value="3"><i class="fa fa-star"></i></span>
                            <span class="star" data-value="4"><i class="fa fa-star"></i></span>
                            <span class="star" data-value="5"><i class="fa fa-star"></i></span>
                        </div>
                        <!-- Hidden Input to Store Rating Value -->
                        <input type="hidden" name="rating" id="ratingInput" value="0" required>
                    </div>

                    <input name="campaign" type="hidden" value="{{ $campaign->id }}">

                    <div class="form-group">
                        <label class="form--label">@lang('How was your experience?')</label>
                        <textarea name="review" class="form--control" rows="5" placeholder="@lang('Write your review here...')" required>{{ old('review') }}</textarea>
                    </div>

                    <button type="submit" class="btn btn--base w-100">
                        @lang('POST REVIEW')
                    </button>
                </form>
            </div>
        @endif

        <p class="campaign-review__count">
            {{ count($campaign->comments->where('status', Status::PUBLISHED)) }}
            @lang('Reviews')</p>
        <div class="campaign-review__list mb-60" id="commentList">
            @forelse($campaign->comments->where('status', Status::PUBLISHED)->sortByDesc('id') as $comment)
                @include($activeTemplate . 'partials.review_item', [
                    'comment' => $comment,
                ])
            @empty
                <div class="card custom--card  dashboard-sidebar overflow-y-auto">
                    <div class="text-center py-10">
                        @include($activeTemplate . 'partials.empty', [
                            'message' => 'There are no reviews yet!',
                        ])
                    </div>
                </div>
            @endforelse
        </div>
        @if ($campaign->comments->where('status', Status::PUBLISHED)->count() > 10)
            <div class="text-center mt-4">
                <button class="btn btn-outline--base w-15 load-more-btn" data-page="2" data-campaign-id="{{ $campaign->id }}">
                    @lang('Load More')
                </button>
            </div>
        @endif
    </div>
</div>
