@extends($activeTemplate . 'layouts.frontend')
@section('content')
    @php
        session()->forget('DONATION');
    @endphp
    <main class="campaigns-page">
        <section class="all-campaigns my-120">
            <div class="container">
                @if (!blank($campaigns))
                    <div class="row">
                        <div class="col-xl-3">
                            <!--==========================   Campaign-sidebar Start  ==========================-->
                            <div class="campaign-sidebar offcanvas-xl offcanvas-end" tabindex="-1" id="campaignSidebar"
                                aria-labelledby="campaignSidebarLabel">
                                <span class="offcanvas--close" data-bs-dismiss="offcanvas" data-bs-target="#campaignSidebar"
                                    aria-label="Close"><i class="fa-solid fa-angles-right"></i></span>
                                <div class="campaign-sidebar__inner">
                                    <div class="sidebar-card search-card d-none d-xl-block">
                                        <h5 class="sidebar-card__title">@lang('Filter by search')</h5>
                                        <div class="sidebar-card__content">
                                            <form class="no-submit-loader">
                                                <div class="form-group">
                                                    <div class="input-group input--group">
                                                        <input type="text" name="search"
                                                            class="form-control form--control"
                                                            placeholder="@lang('Search Campaign')"
                                                            value="{{ request()->search }}" />
                                                        <button type="button" class="input-group-text name-search"><i
                                                                class="fa fa-search"></i></button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                    <div class="sidebar-card criteria-card">
                                        <h5 class="sidebar-card__title">@lang('Filter by criteria')</h5>
                                        <div class="sidebar-card__content">
                                            <div class="form-group">
                                                <label class="form-check  form--radio" for="criteria1">
                                                    <input class="form-check-input" checked type="radio" name="criteria"
                                                        id="criteria1" value="">
                                                    <span class="form-check-label">@lang('All')</span>
                                                </label>
                                                <label class="form-check  form--radio" for="criteria2">
                                                    <input class="form-check-input" type="radio" name="criteria"
                                                        id="criteria2" value="urgent">
                                                    <span class="form-check-label">@lang('Urgent Campaigns')</span>
                                                </label>
                                                <label class="form-check  form--radio" for="criteria3">
                                                    <input class="form-check-input" type="radio" name="criteria"
                                                        id="criteria3" value="featured">
                                                    <span class="form-check-label">@lang('Featured Campaigns')</span>
                                                </label>
                                                <label class="form-check  form--radio" for="criteria4">
                                                    <input class="form-check-input" type="radio" name="criteria"
                                                        id="criteria4" value="top">
                                                    <span class="form-check-label">@lang('Top Campaigns')</span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="sidebar-card category-card">
                                        <h5 class="sidebar-card__title">@lang('Filter by category')</h5>
                                        <div class="sidebar-card__content">
                                            <ul class="category-card__list">
                                                @php
                                                    $categoryCount = $categories->count();
                                                @endphp
                                                @if ($categoryCount > 0)
                                                    <li class="category-card__item campaign-category" data-id="0">
                                                        <span class="icon"><i class="fa-solid fa-angles-right"></i></span>
                                                        <span class="text">@lang('All')</span>
                                                    </li>
                                                @endif
                                                @forelse ($categories as $category)
                                                    <li class="category-card__item campaign-category {{ request()->category == $category->slug ? 'active' : '' }}"
                                                        data-id="{{ $category->id }}">
                                                        <span class="icon"><i class="fa-solid fa-angles-right"></i></span>
                                                        <span class="text">{{ __($category->name) }}</span>
                                                    </li>
                                                @empty
                                                    <div class="text-center py-3">
                                                        @include($activeTemplate . 'partials.empty', [
                                                            'message' => 'Campaigns not found!',
                                                        ])
                                                    </div>
                                                @endforelse
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="sidebar-card date-card mb-3">
                                        <h5 class="sidebar-card__title">@lang('Filter by date')</h5>
                                        <div class="sidebar-card__content">
                                            <div class="d-flex pb-2">
                                                <div class="date-card__range">
                                                    <input type="text" name="date"
                                                        class="form-control form--control datepicker"
                                                        placeholder="@lang('Select Date')">
                                                    <label for="datepicker" class="date-card__icon"><i
                                                            class="fa fa-calendar"></i></label>
                                                </div>
                                                <button type="button" class="clear-btn clearDate"><i
                                                        class="las la-trash-alt"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!--==========================  Campaign-sidebar End  ==========================-->
                        </div>
                        <div class="col-xl-9">
                            <!--==========================   All-campaigns Start  ==========================-->
                            <div class="row gy-4">
                                <div class="col-12 d-block d-xl-none text-end">
                                    <div class="mobile-filter flex-between">
                                        <div class="input-group input--group">
                                            <input type="text" name="search" class="form-control form--control"
                                                placeholder="@lang('Search Campaign')" value="{{ request()->search }}" />
                                            <button type="button" class="input-group-text name-search"><i
                                                    class="fa fa-search"></i></button>
                                        </div>

                                        <button class="filter-button" type="button" data-bs-toggle="offcanvas"
                                            data-bs-target="#campaignSidebar" aria-controls="campaignSidebar">
                                            <span id="hiddenNav"><i class="las la-filter"></i></span>
                                        </button>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <div class="row main-campaign-view gy-4">
                                        @include('Template::campaign.campaign')
                                    </div>
                                </div>
                            </div>
                            <!--==========================  All-campaigns End  ==========================-->

                        </div>

                    </div>
                @else
                    <div class="text-center">
                        <div class="card custom--card  dashboard-sidebar overflow-y-auto">
                            @include($activeTemplate . 'partials.empty', [
                                'message' => ucfirst(strtolower($pageTitle)) . ' not found!',
                            ])
                        </div>
                    </div>
                @endif
            </div>

            <div class="spinner">
                <div class="spinner-border text-success" role="status">
                    <span class="visually-hidden">@lang('Loading...')</span>
                </div>
            </div>

        </section>

        @if (@$sections->secs != null)
            @foreach (json_decode($sections->secs) as $sec)
                @include($activeTemplate . 'sections.' . $sec)
            @endforeach
        @endif
    </main>
@endsection

@push('script-lib')
    <script src="{{ asset($activeTemplateTrue . 'js/flatpickr.js') }}"></script>
@endpush

@push('style-lib')
    <link href="{{ asset($activeTemplateTrue . 'css/flatpickr.min.css') }}" rel="stylesheet">
@endpush

@if (!app()->bound('slick_assets'))
    @php
        app()->instance('slick_assets', true);
    @endphp

    @push('style-lib')
        <link href="{{ asset($activeTemplateTrue . 'css/slick.css') }}" rel="stylesheet">
    @endpush

    @push('script-lib')
        <script src="{{ asset($activeTemplateTrue . 'js/slick.min.js') }}"></script>
    @endpush
@endif

@push('script')
    <script>
        'use strict';

        (function($) {

            $(".datepicker").flatpickr();
            let data = {};
            data.category_id = 0;
            data.criteria = null;
            data.search = null;
            data.date = '';

            @if (request()->category)
                let categoryId = $('.campaign-category.active').data('id');
                data.category_id = categoryId;
            @endif

            const $spinner = $('.spinner');

            function showSpinner() {
                $spinner.css('display', 'flex'); // Ensures spinner is visible
            }

            function hideSpinner() {
                $spinner.css('display', 'none');
            }

            //Date-Filter and Dateficker-initialize!
            $(".datepicker").flatpickr({
                dateFormat: 'Y-m-d',
                onChange: function(selectedDates, dateStr) {
                    data.date = dateStr;
                    filterCampaigns();
                }
            });

            $('.clearDate').on('click', function() {
                $('.datepicker').val('');
                data.date = '';
                filterCampaigns();
            });

            //Search by name

            $('.name-search').on('click', function() {
                var title = $(this).siblings('input[name="search"]').val();
                data.search = title;
                filterCampaigns();
            });

            $('.name-search').closest('form').on('submit', function(e) {
                e.preventDefault();

                var title = $(this).find('input[name="search"]').val();
                data.search = title;
                filterCampaigns();
            });


            //category filter
            $('.campaign-category').each(function(index) {
                $(this).on('click', function() {
                    data.category_id = $(this).data('id');
                    filterCampaigns();
                    $('.campaign-category').not(this).removeClass('active');
                    $(this).addClass('active');
                });
            });


            // Criteria filter
            $('input[name="criteria"]').on('change', function() {
                data.criteria = $(this).val();
                $('input[name="criteria"]').prop('checked', false);
                $(this).prop('checked', true);
                if ($(this).prop('checked')) {
                    filterCampaigns();
                }
            });

            $(document).on('click', '.page-link', function(e) {
                e.preventDefault();

                let pageUrl = $(this).attr('href');
                const url = new URL(pageUrl);
                const pageValue = url.searchParams.get("page");
                data.page = pageValue;

                filterCampaigns();

            });

            function filterCampaigns() {
                showSpinner();
                $.ajax({
                    url: "{{ route('campaign.filter') }}",
                    method: 'GET',
                    data: data,
                    success: function(response) {
                        $('.main-campaign-view').html(response)
                    },
                    error: function(xhr) {
                        console.error('Error occurred:', xhr.responseText);
                    },
                    complete: function() {
                        hideSpinner();
                    }
                });
            };

            // ========================= Slick Slider Js Start ==============
            // banner-Slider-Start//
            $('.cate-slider').slick({
                autoplay: true,
                dots: false,
                arrows: false,
                infinite: true,
                speed: 600,
                slidesToShow: 4,
                slidesToScroll: 1,
                responsive: [{
                        breakpoint: 1024,
                        settings: {
                            slidesToShow: 3,
                            slidesToScroll: 3,
                            infinite: true,
                            dots: false
                        }
                    },
                    {
                        breakpoint: 600,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 2
                        }
                    },
                    {
                        breakpoint: 480,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1
                        }
                    }
                ]
            });

            // banner-Slider-End//

            // ========================= Slick Slider Js End ===================

        })(jQuery);
    </script>
@endpush

@push('style')
    <style>
        .spinner {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.8);
            z-index: 1050;
            display: none;
            justify-content: center;
            align-items: center;
        }

        .spinner .spinner-border {
            width: 3rem;
            height: 3rem;
        }
    </style>
@endpush
