@php
    $contactContent = getContent('contact_us.content', true);
@endphp

@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <main class="contact-page">
        <section class="contact-page__inner my-120">
            <div class="container">
                <div class="row">
                    <div class="col-xl-6">
                        <div class="section-heading style-left">
                            <div class="section-heading__name">
                                <div class="hand-love-icon ">
                                    <span class="icon-hand"><span class="icon-g1135"></span></span>
                                    <span class="icon-love"><i class="fa-regular fa-heart"></i></span>
                                </div>
                                <span class="text">{{ __(@$contactContent->data_values->title) }}</span>
                            </div>
                            <h2 class="section-heading__title">{{ __(@$contactContent->data_values->heading) }}</h2>
                        </div>

                        <div class="address-card-wrapper">
                            <div class="row gy-4">
                                <div class="col-md-6">
                                    <div class="address-card">
                                        <div class="address-card__thumb">
                                            <img src="{{ getImage($activeTemplateTrue . 'contact_icons/map-icon.png') }}" alt="img">
                                        </div>
                                        <div class="address-card__info">
                                            <h5 class="address-card__title">@lang('Address')</h5>
                                            <p class="address-card__desc">{{ __(@$contactContent->data_values->address) }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="address-card">
                                        <div class="address-card__thumb">
                                            <img src="{{ getImage($activeTemplateTrue . 'contact_icons/phone-icon.png') }}" alt="img">
                                        </div>
                                        <div class="address-card__info">
                                            <h5 class="address-card__title">@lang('Phone number')</h5>
                                            <p class="address-card__desc">
                                                <a href="tel:{{ @$contactContent->data_values->phone_one }}">{{ @$contactContent->data_values->phone_one }}</a>
                                                <a href="tel:{{ @$contactContent->data_values->phone_two }}">{{ @$contactContent->data_values->phone_two }}</a>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="address-card">
                                        <div class="address-card__thumb">
                                            <img src="{{ getImage($activeTemplateTrue . 'contact_icons/email-icon.png') }}" alt="img">
                                        </div>
                                        <div class="address-card__info">
                                            <h5 class="address-card__title">@lang('Email address')</h5>
                                            <p class="address-card__desc">
                                                <a href="mailto:{{ @$contactContent->data_values->email_one }}">{{ @$contactContent->data_values->email_one }}</a>
                                                <a href="mailto:{{ @$contactContent->data_values->email_two }}">{{ @$contactContent->data_values->email_two }}</a>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="address-card">
                                        <div class="address-card__thumb">
                                            <img src="{{ getImage($activeTemplateTrue . 'contact_icons/message-icon.png') }}" alt="img">
                                        </div>
                                        <div class="address-card__info">
                                            <h5 class="address-card__title">@lang('Live support')</h5>
                                            <p class="address-card__desc">
                                                <a href="tel:{{ @$contactContent->data_values->live_support_number_one }}">{{ @$contactContent->data_values->live_support_number_one }}</a>
                                                <a href="tel:{{ @$contactContent->data_values->live_support_number_two }}">{{ @$contactContent->data_values->live_support_number_two }}</a>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <a href="tel:123456789" class="whatsapp-contact">
                            <span class="whatsapp-contact__icon">
                                <i class="fa-brands fa-whatsapp"></i>
                            </span>
                            <div class="whatsapp-contact__text">{{ @$contactContent->data_values->whatsapp_number }}</div>
                        </a>
                    </div>
                    <div class="col-xl-6">
                        <div class="contact-thumb">
                            <img src="{{ frontendImage('contact_us', @$contactContent->data_values->image, '475x620') }}" alt="img">
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <section class="contact-page__map my-120">
            <span class="section-overlay">
                <img src="{{ frontendImage('contact_us', @$contactContent->data_values->background_image, '1905x730') }}" alt="img">
            </span>
            <div class="container">
                <div class="contact-form">
                    <div class="row g-0  flex-row-reverse">
                        <div class="col-md-6">
                            <div class="contact-page__content">
                                <h1 class="contact-page__title">{{ @$contactContent->data_values->form_title }}</h1>
                                <form class="contact-page__form verify-gcaptcha" method="POST">
                                    @csrf
                                    <div class="form-group">
                                        <label class="form--label">@lang('Your Name')</label>
                                        <input type="text" name="name" class="form--control" value="{{ old('name', @$user->fullname) }}" placeholder="@lang('Enter Your Full Name')" @if ($user && $user->profile_complete) readonly @endif required>
                                    </div>
                                    <div class="form-group">
                                        <label class="form--label">@lang('Your Email')</label>
                                        <input type="email" name="email" class="form--control" value="{{ old('email', @$user->email) }}" placeholder="@lang('Enter Email')" {{ $user ? 'readonly' : '' }} required>
                                    </div>
                                    <div class="form-group">
                                        <label class="form--label">@lang('Subject')</label>
                                        <input type="text" name="subject" value="{{ old('subject') }}" class="form--control" placeholder="@lang('Enter Your Subject')" required>
                                    </div>
                                    <div class="form-group">
                                        <label class="form--label">@lang('I would like to discuss')</label>
                                        <textarea name="message" class="form--control" required placeholder="@lang('Enter your message...')">{{ old('message') }}</textarea>
                                    </div>

                                    <x-captcha />

                                    <button type="submit" class="btn btn--base w-100">@lang('Get Free Consultation')</button>
                                </form>
                            </div>
                        </div>
                        <div class="col-md-6 overflow-hidden">
                            <iframe src="{{ @$contactContent->data_values->map_url }}" width="800" height="100%" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        @if (@$sections->secs != null)
            @foreach (json_decode($sections->secs) as $sec)
                @include($activeTemplate . 'sections.' . $sec)
            @endforeach
        @endif
    </main>
@endsection
