<div class="offcanvas-xl offcanvas-start p-0 p-lg-0 p-sm-2 " tabindex="-1" id="offcanvasRight">
    <button type="button" class="offcanvas--close d-xl-none d-flex z-2" data-bs-dismiss="offcanvas" data-bs-target="#offcanvasRight">
        <i class="fa-solid fa-angles-left"></i>
    </button>
    <div class="card custom--card  dashboard-sidebar overflow-y-auto">
        <div class="sidebar-profile flex-align">
            <div class="sidebar-profile__thumb">
                @if (auth()->check() && auth()->user()->image)
                    <img src="{{ getImage(getFilePath('userProfile') . '/' . auth()->user()->image, getFileSize('userProfile')) }}" alt="User Image">
                @else
                    <img src="{{ asset('assets/images/user/avatar.png') }}" alt="Default Avatar">
                @endif
            </div>
            <div class="sidebar-profile__info">
                @if (auth()->check())
                    <h5 class="sidebar-profile__name">{{ auth()->user()->username }}</h5>
                    <p class="sidebar-profile__email">{{ auth()->user()->email }}</p>

                    <a href="{{ route('profile.index', auth()->user()->username) }}" class="sidebar-profile__btn btn btn--base">
                        <span class="icon"><i class="fa-regular fa-eye"></i></span> @lang('View Profile')
                    </a>
                @else
                    <h5 class="sidebar-profile__name">@lang('Guest')</h5>
                    <p class="sidebar-profile__email">@lang('Not logged in')</p>

                    <a href="{{ route('user.login') }}" class="sidebar-profile__btn btn btn--base">
                        <span class="icon"><i class="fa-solid fa-right-to-bracket"></i></span> @lang('Log In')
                    </a>
                @endif
            </div>
        </div>
        <nav class="sidebar-menu">
            <a href="{{ route('user.home') }}" class="sidebar-menu__item {{ menuActive('user.home') }}">
                <span class="icon"><i class="fa-solid fa-house-user"></i></span>
                <span class="text">@lang('Dashboard')</span>
            </a>
            <a href="{{ route('user.profile.setting') }}" class="sidebar-menu__item {{ menuActive(['user.profile.setting', 'user.change.password', 'user.twofactor', 'user.profile.organization', 'user.org.award', 'user.org.donor', 'user.org.update']) }}">
                <span class="icon"><i class="fa-regular fa-user"></i></span>
                <span class="text">@lang('My Profile')</span>
            </a>
            <div class="gap-2 bg-transparent flex-wrap {{ menuActive(['user.campaign.fundrise.all', 'user.campaign.fundrise.approved', 'user.campaign.fundrise.pending', 'user.campaign.fundrise.complete', 'user.campaign.fundrise.rejected']) }}">
                <span class="has-dropdown d-block flex-fill w-100 sidebar-menu__item cursor-pointer">
                    <span class="icon"><i class="fa-solid fa-bullseye"></i></span>
                    <span class="text">@lang('My Campaigns')</span>
                </span>
                <div class="sidebar-submenu flex-fill w-100 ms-3 mb-2">
                    <ul class="sidebar-submenu-list d-flex flex-column gap-2">
                        <li class="sidebar-submenu-list__item">
                            <a href="{{ route('user.campaign.fundrise.all') }}" class="sidebar-menu__item {{ menuActive(['user.campaign.fundrise.all']) }}">
                                <span class="icon"><i class="fa-solid fa-chart-simple"></i></span>
                                <span class="text">@lang('All Campaigns')</span>
                            </a>
                        </li>
                        <li class="sidebar-submenu-list__item">
                            <a href="{{ route('user.campaign.fundrise.approved') }}" class="sidebar-menu__item {{ menuActive('user.campaign.fundrise.approved') }}">
                                <span class="icon"><i class="fa-solid fa-check-double"></i></span>
                                <span class="text">@lang('Approved Campaigns')</span>
                            </a>
                        </li>
                        <li class="sidebar-submenu-list__item">
                            <a href="{{ route('user.campaign.fundrise.pending') }}" class="sidebar-menu__item {{ menuActive('user.campaign.fundrise.pending') }}">
                                <span class="icon"><i class="fa-solid fa-spinner"></i></span>
                                <span class="text">@lang('Pending Campaigns')</span>
                            </a>
                        </li>
                        <li class="sidebar-submenu-list__item">
                            <a href="{{ route('user.campaign.fundrise.complete') }}" class="sidebar-menu__item {{ menuActive('user.campaign.fundrise.complete') }}">
                                <span class="icon"><i class="fa-solid fa-list"></i></span>
                                <span class="text">@lang('Successful Campaigns')</span>
                            </a>
                        </li>
                        <li class="sidebar-submenu-list__item">
                            <a href="{{ route('user.campaign.fundrise.rejected') }}" class="sidebar-menu__item {{ menuActive('user.campaign.fundrise.rejected') }}">
                                <span class="icon"><i class="fa-regular fa-circle-xmark"></i></span>
                                <span class="text">@lang('Rejected Campaigns')</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            <a href="{{ route('user.favorite.index') }}" class="sidebar-menu__item {{ menuActive('user.favorite.index') }}">
                <span class="icon"><i class="fa-solid fa-square-poll-horizontal"></i></span>
                <span class="text">@lang('Favorite Campaigns')</span>
            </a>
            <a href="{{ route('user.transactions') }}" class="sidebar-menu__item {{ menuActive('user.transactions') }}">
                <span class="icon"><i class="fa-solid fa-right-left"></i></span>
                <span class="text">@lang('Transactions')</span>
            </a>
            <a href="{{ route('user.withdraw.history') }}" class="sidebar-menu__item {{ menuActive(['user.withdraw.history', 'user.withdraw', 'user.withdraw.preview']) }}">
                <span class="icon"><i class="fa-solid fa-money-bill-transfer"></i></span>
                <span class="text">@lang('Withdrawals')</span>
            </a>
            <a href="{{ route('user.campaign.donation.received') }}" class="sidebar-menu__item {{ menuActive('user.campaign.donation.received') }}">
                <span class="icon"><i class="fa-solid fa-handshake-angle"></i></span>
                <span class="text">@lang('Received Donations')</span>
            </a>
            <a href="{{ route('user.campaign.donation.given') }}" class="sidebar-menu__item {{ menuActive('user.campaign.donation.given') }}">
                <span class="icon"><i class="fa-solid fa-circle-dollar-to-slot"></i></span>
                <span class="text">@lang('Given Donations')</span>
            </a>
            <a href="{{ route('ticket.index') }}" class="sidebar-menu__item {{ menuActive(['ticket.index', 'ticket.open', 'ticket.view']) }}">
                <span class="icon"><i class="fa-solid fa-headset"></i></span>
                <span class="text">@lang('Support Ticket')</span>
            </a>
            <a href="{{ route('user.referrals') }}" class="sidebar-menu__item {{ menuActive(['user.referrals']) }}">
                <span class="icon"><i class="las la-users"></i></span>
                <span class="text">@lang('Referrals')</span>
            </a>
            <a href="{{ route('user.logout') }}" class="sidebar-menu__item bg--danger text-white">
                <span class="icon"><i class="fa-solid fa-arrow-right-from-bracket"></i></span>
                <span class="text">@lang('Logout')</span>
            </a>
        </nav>
    </div>
</div>
