@php
    $socialElements = getContent('social_icon.element', orderById: true);
    $subscribeContent = getContent('subscribe.content', true);
    $footerContent = getContent('footer.content', true);
    $policyPages = getContent('policy_pages.element');
    $categoryQuery = App\Models\Category::active()->hasCampaigns()->orderBy('id', 'DESC');
    $categories = $categoryQuery->take(3)->get();
@endphp

<footer class="footer-area">
    <div class="footer-area__layer">
        <img src="{{ frontendImage('footer', @$footerContent->data_values->background_image, '1920x75') }}" alt="img">
    </div>
    <div class="pb-60 pt-120">
        <div class="container">
            <div class="row justify-content-center gy-5">
                <div class="col-xl-4 col-sm-6 col-xsm-6">
                    <div class="footer-item">
                        <div class="footer-item__logo">
                            <a href="{{ route('home') }}"> <img src="{{ siteLogo() }}" alt="logo"></a>
                        </div>
                        <p class="footer-item__desc">
                            {{ __(@$footerContent->data_values->short_description) }} </p>
                        <ul class="social-list">
                            @foreach ($socialElements as $socialElement)
                                <li class="social-list__item">
                                    <a href="{{ @$socialElement->data_values->url }}" target="_blank" class="social-list__link flex-center">
                                        @php echo @$socialElement->data_values->social_icon @endphp
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
                <div class="col-xl-2 col-sm-6 col-xsm-6">
                    <div class="footer-item">
                        <h5 class="footer-item__title">@lang('Useful Link')</h5>
                        <ul class="footer-menu">
                            <li class="footer-menu__item"><a href="{{ route('campaign.index') }}" class="footer-menu__link"><i class="fa-solid fa-angles-right"></i> @lang('Campaigns') </a></li>
                            <li class="footer-menu__item"><a href="{{ route('success.story.archive') }}" class="footer-menu__link"><i class="fa-solid fa-angles-right"></i> @lang('Success Stories') </a></li>
                            <li class="footer-menu__item"><a href="{{ route('contact') }}" class="footer-menu__link"><i class="fa-solid fa-angles-right"></i> @lang('Contact') </a></li>
                        </ul>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6 col-xsm-6">
                    <div class="footer-item">
                        <h5 class="footer-item__title">@lang('Fundraise for')</h5>
                        <ul class="footer-menu">
                            @foreach ($categories as $category)
                                <li class="footer-menu__item">
                                    <a class="footer-menu__link" href="{{ route('campaign.index', ['category' => $category->slug]) }}">
                                        <i class="fa-solid fa-angles-right"></i> {{ __($category->name) }}
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6 col-xsm-6">
                    <div class="footer-item mb-4">
                        <h5 class="footer-item__title">{{ __(@$subscribeContent->data_values->heading) }}</h5>
                        <ul class="footer-contact-menu">
                            <li class="footer-contact-menu__item text-white">
                                {{ __(@$subscribeContent->data_values->subheading) }}
                            </li>
                            <li class="footer-contact-menu__item">
                                <form class="footer-form subscribe-form">
                                    @csrf
                                    <div class="input-group input--group style-two">
                                        <input type="email" name="email" class="form-control form--control" placeholder="@lang('Enter your email')" required>
                                        <button type="submit" class="input-group-text"><i class="icon-send-2-1"></i></button>
                                    </div>
                                </form>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Footer Top End-->

    <!-- bottom Footer -->
    <div class="bottom-footer py-3">
        <div class="container">
            <div class="row gy-3 justify-content-between align-items-center flex-row-reverse">

                <div class="col-xl-6 text-xl-end text-center">
                    <div class="bottom-footer-text text-white">
                        @foreach (@$policyPages as $policy)
                            <a href="{{ route('policy.pages', $policy->slug) }}" class="me-2 flex-align footer-menu__link d-inline-flex gap-2">
                                <i class="fa-solid fa-circle fs-10"></i> {{ __(@$policy->data_values->title . ' ') }}
                            </a>
                        @endforeach
                    </div>
                </div>
                <div class="col-xl-6 text-xl-start text-center">
                    <div class="bottom-footer-text text-white">
                        &copy; @lang('Copyright ') {{ date('Y') }}.
                        @lang('All rights reserved') <a href="{{ route('home') }}" class="text--base">{{ __(@gs('site_name')) }}</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

</footer>

@push('script')
    <script>
        'use strict';
        (function($) {
            $('.subscribe-form').on('submit', function(event) {
                event.preventDefault();
                const formData = new FormData($(this)[0]);
                $.ajax({
                    url: "{{ route('subscribe') }}",
                    type: "POST",
                    cache: false,
                    contentType: false,
                    processData: false,
                    data: formData,
                    success: function(response) {
                        $('.subscribe-form').trigger('reset');
                        if (response.success) {
                            notify('success', response.message);
                        } else {
                            notify('error', response.message);
                        }
                    }
                });
            });
        })(jQuery);
    </script>
@endpush
