@php
    $headerContent = getContent('header.content', true);
    $socialElements = getContent('social_icon.element', orderById: true);
@endphp

<div class="header-top">
    <div class="container">
        <div class="top-header-wrapper">
            <div class="header-top__left">
                <ul class="contact-list">
                    <li class="contact-list__item">
                        <span class="contact-list__item-icon"><i class="fa-solid fa-phone-volume"></i></span>
                        <a href="tel:{{ @$headerContent->data_values->phone }}" class="contact-list__link">
                            <span class="title">{{ @$headerContent->data_values->phone }}</span>
                            <span class="susbtitle">{{ __(@$headerContent->data_values->phone_sub_title) }}</span>
                        </a>
                    </li>
                    <li class="contact-list__item">
                        <span class="contact-list__item-icon"><i class="far fa-envelope"></i></span>
                        <a href="mailto:{{ @$headerContent->data_values->email }}" class="contact-list__link">
                            <span class="title">{{ @$headerContent->data_values->email }}</span>
                            <span class="susbtitle">{{ __(@$headerContent->data_values->email_sub_title) }}</span>
                        </a>
                    </li>
                </ul>
            </div>
            <div class="header-top__right">
                <ul class="social-icon">
                    @foreach ($socialElements as $socialElement)
                        <li class="social-icon__item">
                            <a href="{{ @$socialElement->data_values->url }}" target="_blank">
                                @php echo(@$socialElement->data_values->social_icon) @endphp
                            </a>
                        </li>
                    @endforeach
                </ul>

                @include('Template::partials.language')

                @auth
                    <div class="top-login">
                        <a href="{{ route('user.home') }}">
                            <span class="top-login__icon">
                                <i class="fa-solid fa-gauge"></i>
                            </span>
                            <span class="top-login__text">@lang('Dashboard')</span>
                        </a>
                    </div>
                @else
                    <div class="top-login">
                        <a href="{{ route('user.login') }}">
                            <span class="top-login__icon">
                                <i class="fa-solid fa-circle-user"></i>
                            </span>
                            <span class="top-login__text">@lang('Login')</span>
                        </a>
                    </div>
                @endauth
            </div>
        </div>
    </div>
</div>

<header class="header" id="header">
    <div class="container">
        <nav class="navbar navbar-expand-xl">
            <a class="navbar-brand logo" href="{{ route('home') }}"><img src="{{ siteLogo('dark') }}" alt="logo"></a>
            <button class="navbar-toggler header-button" type="button" data-bs-toggle="offcanvas" data-bs-toggle="offcanvas" data-bs-target="#offcanvasExample" aria-controls="offcanvasExample" aria-expanded="false" aria-label="Toggle navigation">
                <span id="hiddenNav"><i class="las la-bars"></i></span>
            </button>
            <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasExample" aria-labelledby="offcanvasExampleLabel">
                <span class="offcanvas--close d-xl-none d-flex" data-bs-dismiss="offcanvas" aria-label="Close"><i class="fa-solid fa-angles-left"></i></span>
                <div class="offcanvas-header">
                    <a class="navbar-brand logo" href="{{ route('home') }}"><img src="{{ siteLogo() }}" alt="img"></a>
                    @include($activeTemplate . 'partials.language')
                </div>
                <div class="offcanvas-body justify-content-end">
                    <div class="offcanvas__body flex-between">
                        <ul class="navbar-nav nav-menu align-items-xl-center">
                            <li class="nav-item">
                                <a class="nav-link {{ menuActive('home') }}" href="{{ route('home') }}">@lang('Home')</a>
                            </li>

                            @foreach ($pages as $k => $data)
                                <li class="nav-item">
                                    <a class="nav-link {{ menuActive('pages', null, $data->slug) }}" href="{{ route('pages', [$data->slug]) }}">{{ __($data->name) }}</a>
                                </li>
                            @endforeach

                            <li class="nav-item">
                                <a class="nav-link {{ menuActive('campaign.index') }}" href="{{ route('campaign.index') }}">@lang('Campaign')</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link {{ menuActive('volunteer.index') }}" href="{{ route('volunteer.index') }}">@lang('Volunteer')</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link {{ menuActive('success.story.archive') }}" href="{{ route('success.story.archive') }}">@lang('Success Story')</a>
                            </li>
                            <li class="nav-item d-block d-xl-none">
                                <a class="nav-link {{ menuActive('contact') }}" href="{{ route('contact') }}">@lang('Contact')</a>
                            </li>
                        </ul>

                        @auth
                            <a href="{{ route('user.campaign.fundrise.create') }}" class="contact-link nav-link d-xl-block d-none">
                                <span class="text">@lang('Start A Campaign')</span>
                                <span class="icon"><i class="fa-solid fa-arrow-right-long"></i></span>
                            </a>
                        @else
                            <a href="{{ route('contact') }}" class="contact-link nav-link d-xl-block d-none">
                                <span class="text">@lang('Contact With Us')</span>
                                <span class="icon"><i class="fa-solid fa-arrow-right-long"></i></span>
                            </a>
                        @endauth
                    </div>

                </div>
                <div class="offcanvas-footer d-xl-none">
                    <div class="contact-info">
                        <h4 class="contact-info__title">@lang('Contact Information')</h4>
                        <span class="contact-info__list">
                            <a class="contact-info__list-item" href="tel:{{ @$headerContent->data_values->phone }}"><span class="icon"><i class="fa-solid fa-phone"></i></span>
                                {{ @$headerContent->data_values->phone }}</a>
                            <a class="contact-info__list-item" href="mailto:{{ @$headerContent->data_values->email }}"><span class="icon"><i class="fa-solid fa-envelope"></i></span>
                                {{ @$headerContent->data_values->email }}</a>
                        </span>
                        <span class="social-info__list">
                            @foreach ($socialElements as $socialElement)
                                <a class="social-info__list-item" href="{{ @$socialElement->data_values->url }}" target="_blank">
                                    @php echo(@$socialElement->data_values->social_icon) @endphp
                                </a>
                            @endforeach
                        </span>
                    </div>
                    @auth
                        <a href="{{ route('user.home') }}" class="contact-link nav-link">
                            <span class="text">@lang('Dashboard')</span>
                            <span class="icon"><i class="fa-solid fa-gauge"></i></span>
                        </a>
                    @else
                        <a href="{{ route('user.login') }}" class="contact-link nav-link">
                            <span class="text">@lang('Login')</span>
                            <span class="icon"><i class="fa-solid fa-arrow-right-long"></i></span>
                        </a>
                    @endauth
                </div>
            </div>
        </nav>
    </div>
</header>
