@if (gs('multi_language'))
@php
$language = App\Models\Language::all();
$activeLanguage = App\Models\Language::where('code', session('lang'))->first();
@endphp

<div class="language-dropdown">
    <div class="dropdown">
        <button class="dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
            <span class="icon"><img src="{{ getImage(getFilePath('language') . '/' . $activeLanguage->image, getFileSize('language')) }}" alt="image"></span>
            <span class="text">{{ $activeLanguage->name }}</span>
        </button>
        <ul class="dropdown-menu">
            @foreach ($language as $item)
            @if ($item->id != $activeLanguage->id)
            <li class="language-dropdown__item langSel" data-value="{{ $item->code }}">
                <span class="icon"><img src="{{ getImage(getFilePath('language') . '/' . $item->image, getFileSize('language')) }}" alt="image"> </span>
                <span class="text">{{ $item->name }}</span>
            </li>
            @endif
            @endforeach
        </ul>
    </div>
</div>
@endif
