@php
    $registrationDisabled = getContent('register_disable.content', true);
@endphp
<div class="register-disable">
    <div class="container">
        <div class="row d-flex justify-content-center">
            <div class="col-12">
                <div class="register-disable-image mb-3">
                    <i class="las la-user-lock"></i>
                </div>

                <h5 class="register-disable-title text-center">{{ __(@$registrationDisabled->data_values->heading) }}
                </h5>
                <p class="register-disable-desc">
                    {{ __(@$registrationDisabled->data_values->subheading) }}
                </p>
                <div class="text-center">
                    <a class="btn btn--base"
                        href="{{ @$registrationDisabled->data_values->button_url }}">
                        <span class="btn--icon"><i class="fa-solid fa-home-alt"></i> </span>
                        {{ __(@$registrationDisabled->data_values->button_name) }}
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@push('style')
    <style>
        .register-disable-image {
            margin-bottom: 32px;
            font-size: 220px;
            line-height: 1;
            text-align: center;
            px;
        }

        .register-disable-title {
            color: rgb(0 0 0 / 80%);
            font-size: 42px;
            margin-bottom: 18px;
            text-align: center
        }

        .register-disable-icon {
            font-size: 16px;
            background: rgb(255, 15, 15, .07);
            color: rgb(255, 15, 15, .8);
            border-radius: 3px;
            padding: 6px;
            margin-right: 4px;
        }

        .register-disable-desc {
            color: rgb(0 0 0 / 50%);
            font-size: 18px;
            max-width: 565px;
            width: 100%;
            margin: 0 auto 32px;
            text-align: center;
        }
    </style>
@endpush
