<div class="user-details__banner">
    @if ($user->enable_org)
        <img src="{{ cover(@$user->organization->cover ? getFilePath('orgCover') . '/' . @$user->organization->cover : null, true) }}" alt="img">
    @else
        <img src="{{ cover(@$user->cover ? getFilePath('userCover') . '/' . @$user->cover : null, false) }}" alt="img">
    @endif
</div>
<div class="user-details__header">
    <div class="user-details__thumb">
        @if ($user->enable_org)
            <img src="{{ avatar(@$user->organization->image ? getFilePath('orgProfile') . '/' . @$user->organization->image : null, false) }}" alt="user-avatar">
        @else
            <img src="{{ avatar(@$user->image ? getFilePath('userProfile') . '/' . @$user->image : null, false) }}" alt="user-avatar">
        @endif 
    </div>
    <div class="user-details__info">
        <h2 class="user-details__name">
            <span class="icon"><i class="las la-user"></i></span>
            @if ($user->enable_org)
                <span class="text">{{ __($user->organization->name) }}</span>
            @else
                <span class="text"> {{ __($user->fullname) }}</span>
            @endif
        </h2>
        @if ($user->enable_org)
        <div class="text"> <span class="ico"><i class="las la-tags"></i></span>
            {{ __($user->organization->tagline) }}
        </div>
        @else 
        <p class="user-details__joined">
            <span class="icon"><i class="fa-regular fa-calendar-days"></i></span>
            <span class="text">@lang('Joined at') {{ showDateTime($user->created_at, 'Y-m-d h:i A') }} </span>
        </p>
        @endif 
    </div>
    @include($activeTemplate . 'partials.share')
</div>
<div class="user-details__menu">
    <a class="user-details__menu-list {{ menuActive('profile.index',$user->username) }}" href="{{ route('profile.index',$user->username) }}">
        <span class="icon"><i class="fa-solid fa-volume-high"></i></span>
        <span class="text">@lang('Campaigns')</span>
    </a>
    <a class="user-details__menu-list {{ menuActive('profile.info', $user->username) }}" href="{{ route('profile.info', $user->username) }}">
        <span class="icon"><i class="fa-solid fa-file-alt"></i></span>
        <span class="text">@lang('Description')</span>
    </a>
    @if ($user->enable_org)
    <a class="user-details__menu-list {{ menuActive('profile.award', $user->username) }}" href="{{ route('profile.award', $user->username) }}">
        <span class="icon"><i class="fa-solid fa-volume-high"></i></span>
        <span class="text">@lang('Awards')</span>
    </a>
    <a class="user-details__menu-list {{ menuActive('profile.donor', $user->username) }}" href="{{ route('profile.donor', $user->username) }}">
        <span class="icon"><i class="fa-solid fa-file-alt"></i></span>
        <span class="text">@lang('Donors Wall')</span>
    </a>
    <a class="user-details__menu-list {{ menuActive('profile.update', $user->username) }}" href="{{ route('profile.update', $user->username) }}">
        <span class="icon"><i class="fa-solid fa-volume-high"></i></span>
        <span class="text">@lang('Update')</span>
    </a>
    @endif 
</div>