<div class="col-12">
    <div class="row gy-4">
        <div class="col-12 d-block d-xl-none text-end">
            <div class="mobile-filter flex-between">
                <a href="{{ route('volunteer.form') }}" role="button" class="btn btn--base flex-fill volunteer-btn">@lang('Became a member')</a>
                <button class="filter-button" type="button" data-bs-toggle="offcanvas" data-bs-target="#campaignSidebar" aria-controls="campaignSidebar">
                    <span id="hiddenNav"><i class="las la-filter"></i></span>
                </button>
            </div>
        </div>
        @forelse($volunteers as $volunteer)
            <div class="col-lg-4 col-sm-6 col-xsm-6">
                <div class="team-card">
                    <div class="team-card__thumb">
                        <img class="fit-image" src="{{ getImage(getFilePath('volunteer') . '/' . $volunteer->image, getFileSize('volunteer')) }}" alt="img">
                    </div>
                    <div class="team-card__context">
                        <h6 class="team-card__name">{{ __($volunteer->fullname) }}</h6>
                        <p class="p team-card__designation">@lang("Participated {$volunteer->participated} Campaigns")</p>
                        <p class="designation"><strong class="text--base"> @lang('From')</strong> :
                            {{ __(@$volunteer->country) }}</p>
                    </div>
                </div>
            </div>
        @empty
            <div class="text-center">
                <div class="card custom--card dashboard-sidebar overflow-y-auto">
                    @include($activeTemplate . 'partials.empty', [
                        'message' => ucfirst(strtolower($pageTitle)) . ' not found!',
                    ])
                </div>
            </div>
        @endforelse
    </div>
</div>
