@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <main class="user-page">
        <section class="dashboard">
            <div class="container my-120">
                <div class="user-details">
                    @include($activeTemplate . 'partials.user_header')
                    <div class="user-details__content">
                        <div class="row gy-4 justify-content-center">
                            @if (!blank($user->organization->awards))
                                @foreach ($user->organization->awards as $award)
                                    <div class="col-lg-4 col-md-6">
                                        <div class="blog-item card custom--card card-style-two">
                                            <div class="card-thumb">
                                                <span class="w-100 blog-item__thumb">
                                                    <img src="{{ getImage(getFilePath('orgAward') . '/' . $award->image, getFileSize('orgAward')) }}"class="fit-image w-100"
                                                        alt="">
                                                </span>
                                            </div>
                                            <div class="card-body">
                                                <span class="blog-time">
                                                    <span class="blog-time__icon text--base">
                                                        <i class="fa-solid fa-award"></i></span>
                                                    {{ __($award->title) }}
                                                </span>
                                                <h4 class="blog-item__title text--base">{{ __($award->institute) }}</h4>
                                                <p class="blog-item__desc mb-0">{{ __($award->contribution) }}</p>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            @else
                                <div class="card custom--card  dashboard-sidebar overflow-y-auto">
                                    <div class="col-12 text-center">
                                        @include($activeTemplate . 'partials.empty', [
                                            'message' => 'Not awarded yet!',
                                        ])
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>
@endsection

@push('style')
    <style>
        .user-info__title {
            margin-bottom: 3px;
        }
    </style>
@endpush
