@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <main class="user-page">
        <section class="dashboard my-120">
            <div class="container">
                <div class="user-details">
                    @include($activeTemplate . 'partials.user_header')
                    <div class="user-details__content">
                        @if (!blank($campaigns))
                            <div class="ms-auto mb-3">
                                <form class="header-search-from">
                                    <div class="input-group style-two">
                                        <input type="search" class="form-control form--control bg-white" name="search"
                                            value="{{ request()->search }}" placeholder="@lang('Search by title')">
                                        <button class="input-group-text bg--base text-white">
                                            <i class="fa-solid fa-magnifying-glass"></i>
                                        </button>
                                    </div>
                                </form>
                            </div>
                            <table class="table custom--table table--responsive--md">
                                <thead>
                                    <tr>
                                        <th>@lang('TITLE')</th>
                                        <th>@lang('NAME')</th>
                                        <th>@lang('GOAL')</th>
                                        <th>@lang('RAISED')</th>
                                        <th>@lang('CREATED AT')</th>
                                        <th>@lang('ACTION')</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($campaigns as $campaign)
                                        @php
                                            $campDonation = $campaign->donations
                                                ->where('status', Status::DONATION_PAID)
                                                ->sum('donation');
                                        @endphp
                                        <tr>
                                            <td>
                                                <a href="{{ route('campaign.details', $campaign->slug) }}">
                                                    {{ __(strLimit($campaign->title, 20)) }}
                                                </a>
                                            </td>
                                            <td>
                                                <div class="d-flex align-items-center gap-2">
                                                    <div class="avatar">
                                                        @if ($campaign->user->enable_org)
                                                            <img src="{{ avatar(@$campaign->user->organization->image ? getFilePath('orgProfile') . '/' . @$campaign->user->organization->image : null) }}"
                                                                alt="org-cover-avatar">
                                                        @else
                                                            <img src="{{ avatar(@$campaign->user->image ? getFilePath('userProfile') . '/' . @$campaign->user->image : null) }}"
                                                                alt="user-avatar">
                                                        @endif
                                                    </div>
                                                    <span class="text">
                                                        @if ($campaign->user->enable_org)
                                                            {{ __($campaign->user->Organization->name) }}
                                                        @else
                                                            {{ __($campaign->user->fullname) }}
                                                        @endif
                                                    </span>
                                                </div>
                                            </td>
                                            <td>{{ showAmount($campaign->goal, decimal:false) }}</td>
                                            <td>{{ showAmount($campDonation, decimal:false) }}</td>
                                            <td>{{ showDateTime($campaign->created_at, 'd-m-Y') }}</td>
                                            <td>
                                                <a href="{{ route('campaign.details', $campaign->slug) }}"
                                                    class="action-icon-btn">
                                                    <i class="fa-solid fa-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                            <div class="mt-3">
                                {{ paginateLinks($campaigns) }}
                            </div>
                        @else
                            <div class="card custom--card  dashboard-sidebar overflow-y-auto">
                                <div class="text-center py-3">
                                    @include($activeTemplate . 'partials.empty', [
                                        'message' => 'Campaigns not found!',
                                    ])
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
            </div>
        </section>
    </main>
@endsection
