@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <main class="user-page">
        <section class="dashboard">
            <div class="container my-120">
                <div class="user-details">
                    @include($activeTemplate . 'partials.user_header')
                    <div class="user-details__content">

                        <div class="row gy-4 justify-content-center">
                            @if (!blank($user->organization->donors))
                                @foreach ($user->organization->donors as $donor)
                                    <div class="col-lg-4 col-md-6">
                                        <div class="blog-item card custom--card card-style-two">
                                            <div class="card-thumb">
                                                <span class="w-100 blog-item__thumb">
                                                    <img src="{{ avatar(@$donor->image ? getFilePath('orgDonor') . '/' . @$donor->image : null) }}"class="fit-image w-100"
                                                        alt="">
                                                </span>
                                            </div>
                                            <div class="card-body">
                                                <h4 class="blog-item__title text--base">{{ __($donor->name) }}</h4>
                                                <p class="blog-item__desc mb-0">{{ __($donor->details) }}</p>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            @else
                                <div class="card custom--card  dashboard-sidebar overflow-y-auto">
                                    @include($activeTemplate . 'partials.empty', [
                                        'message' => 'No donation raised yet!',
                                    ])
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </section>
    </main>
@endsection
