@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <main class="user-page">
        <section class="dashboard my-120">
            <div class="container">
                <div class="user-details">
                    @include($activeTemplate . 'partials.user_header')
                    <div class="user-details__content">
                        <div class="row mt-0 gy-4">
                            <div class="col-lg-8">
                                @php
                                    $description = $user->enable_org
                                        ? @$user->organization->description
                                        : @$user->description;
                                    $cleanDescription = trim(strip_tags($description));
                                @endphp
                                @if (!empty($cleanDescription))
                                    <div class="card custom--card  dashboard-sidebar overflow-y-auto">
                                        <div class="my-2">
                                            <p class="user-details__content-text mb-2">{{ $cleanDescription }}</p>
                                        </div>
                                    </div>
                                @else
                                    <div class="card custom--card  dashboard-sidebar overflow-y-auto">
                                        @include($activeTemplate . 'partials.empty', [
                                            'message' => 'Basic information not provided yet!',
                                        ])
                                    </div>
                                @endif
                            </div>
                            <div class="col-lg-4">
                                <div class="card custom--card user-contact">
                                    <h4 class="user-contact__title">@lang('Contact')</h4>
                                    <div class="user-contact__list">
                                        <div class="user-contact__item">
                                            <span class="icon"><i class="fa-solid fa-map-marker-alt"></i></span>
                                            <div class="user-contact__item-info">
                                                <span class="title">@lang('Address')</span>
                                                <span class="text">
                                                    @if ($user->enable_org)
                                                        {{ $user->organization->address->address }}
                                                    @else
                                                        {{ $user->address . ',' . $user->state . ',' . $user->city . ',' . $user->country_name . ' -' . $user->zip }}
                                                    @endif
                                                </span>
                                            </div>
                                        </div>
                                        <div class="user-contact__item">
                                            <span class="icon"><i class="fa-solid fa-phone"></i></span>
                                            <div class="user-contact__item-info">
                                                <span class="title">@lang('Phone')</span>
                                                <span class="text">
                                                    @if ($user->enable_org)
                                                        {{ $user->organization->address->mobile }}
                                                    @else
                                                        {{ $user->mobile }}
                                                    @endif
                                                </span>
                                            </div>
                                        </div>
                                        <div class="user-contact__item">
                                            <span class="icon"><i class="fa-solid fa-envelope-open"></i></span>
                                            <div class="user-contact__item-info">
                                                <span class="title">@lang('Email')</span>
                                                <span class="text">
                                                    @if ($user->enable_org)
                                                        {{ $user->organization->address->email }}
                                                    @else
                                                        {{ $user->email }}
                                                    @endif
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </section>
    </main>
@endsection
