@extends($activeTemplate . 'layouts.frontend')
@section('content')
@php
    $user->organization->orgUpdates = [];
@endphp
    <main class="user-page">
        <section class="dashboard">
            <div class="container my-120">
                <div class="user-details">
                    @include($activeTemplate . 'partials.user_header')
                    <div class="user-details__content">
                        <div class="row mt-0 gy-4">
                            <div class="col-lg-12">
                                <div class="org-update card custom--card p-5">
                                    @if (!blank($user->organization->orgUpdates))
                                        @foreach ($user->organization->orgUpdates as $update)
                                            <div class="campaign-update__items">
                                                <div class="campaign-update__head">
                                                    <span class="icon text--base">
                                                        <i class="fa-regular fa-calendar-days"></i>
                                                    </span>
                                                    <p class="title">
                                                        {{ showDateTime(@$update->date, 'd F, Y') }} ({{ diffForHumans(@$update->date) }})
                                                    </p>
                                                </div>
                                                <div class="campaign-update__body">
                                                    <div class="campaign-update__body-text">
                                                        <span class="icon">
                                                            @lang('#')
                                                        </span>
                                                        <p class="desc">
                                                            {{ __(@$update->updation) }}
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    @else
                                        @include($activeTemplate . 'partials.empty', ['message' => 'Not any update yet!'])
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </section>
    </main>
@endsection