@php
    $aboutContent = getContent('about.content', true);
    $aboutElements = getContent('about.element', orderById: true);
@endphp

<section class="about-us-section my-120">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <div class="about-us__thumb">
                    <span class="mark-img">
                        <img src="{{ frontendImage('about', @$aboutContent->data_values->image, '595x645') }}" alt="img">
                    </span>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="section-heading style-left">
                    <div class="section-heading__name">
                        <div class="hand-love-icon ">
                            <span class="icon-hand"><span class="icon-g1135"></span></span>
                            <span class="icon-love"><i class="fa-regular fa-heart"></i></span>
                        </div>
                        <span class="text">{{ __(@$aboutContent->data_values->title) }}</span>
                    </div>
                    <h2 class="section-heading__title">{{ __(@$aboutContent->data_values->heading) }}</h2>
                </div>
                <div class="about-us__content">
                    <p class="about-us__text">{{ __(@$aboutContent->data_values->short_description) }}</p>
                    <div class="about-us__list">
                        @foreach ($aboutElements as $aboutElement)
                            <div class="about-us__list-item">
                                <span class="about-us__list-item-icon"><i class="fa-regular fa-circle-check"></i></span>
                                <span class="about-us__list-item-text">{{ __(@$aboutElement->data_values->item_text) }}</span>
                            </div>
                        @endforeach
                    </div>
                    <div class="about-us__number counterup-item">
                        <div class="about-us__number-item">
                            <div class="about-us__number-content">
                                <h3 class="about-us__number-value"><span class="odometer" data-odometer-final="{{ shortNumber(@$aboutContent->data_values->total_volunteer ?? 0) }}">@lang('0')
                                    </span>{{ shortNumber(@$aboutContent->data_values->total_volunteer ?? 0, true) }}</h3>
                                <p class="about-us__number-text">@lang('Total Volunteer')</p>
                            </div>
                            <span class="about-us__number-space"></span>
                        </div>
                        <div class="about-us__number-item">
                            <div class="about-us__number-content">
                                <h3 class="about-us__number-value"><span class="odometer" data-odometer-final="{{ shortNumber(@$aboutContent->data_values->happy_donor ?? 0) }}">@lang('0')
                                    </span>{{ shortNumber(@$aboutContent->data_values->happy_donor ?? 0, true) }}</h3>
                                <p class="about-us__number-text">@lang('Happy Doner')</p>
                            </div>
                            <span class="about-us__number-space"></span>
                        </div>
                        <div class="about-us__number-item">
                            <div class="about-us__number-content">
                                <h3 class="about-us__number-value"><span class="odometer" data-odometer-final="{{ shortNumber(@$aboutContent->data_values->total_campaign ?? 0) }}">@lang('0')
                                    </span>{{ shortNumber(@$aboutContent->data_values->total_campaign ?? 0, true) }}</h3>
                                <p class="about-us__number-text">@lang('Total Campaign')</p>
                            </div>
                            <span class="about-us__number-space"></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

@push('style-lib')
    <link href="{{ asset($activeTemplateTrue . 'css/odometer.css') }}" rel="stylesheet">
@endpush

@push('script-lib')
    <script src="{{ asset($activeTemplateTrue . 'js/odometer.min.js') }}"></script>
    <script src="{{ asset($activeTemplateTrue . 'js/viewport.jquery.js') }}"></script>
@endpush
