@php
    $bannerContent = getContent('banner.content', true);
    $bannerElements = getContent('banner.element');
@endphp

<section class="banner-section">
    <div class="overlay-slider">
        @foreach ($bannerElements as $bannerElement)
            <div class="overlay-thumb">
                <img src="{{ frontendImage('banner', @$bannerElement->data_values->image, '1920x760') }}" alt="bg">
            </div>
        @endforeach
    </div>
    <div class="banner-section__layer"></div>
    <div class="container">
        <div class="row">
            <div class="col-xxl-6 col-xxl-8 col-lg-10">
                <div class="banner-content__wrapper">
                    <div class="banner-content">
                        <div class="banner-content__list">
                            @foreach ($bannerElements as $bannerElement)
                                <div class="banner-content__item">
                                    <div class="banner-content__heading">
                                        <h1 class="banner-content__title">
                                            {{ __(@$bannerElement->data_values->heading) }}</h1>
                                        <p class="banner-content__desc">
                                            {{ __(@$bannerElement->data_values->subheading) }}
                                        </p>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="banner-content__button">
                            <a href="{{ @$bannerContent->data_values->button_one_url }}" class="btn btn--base">
                                {{ __(@$bannerContent->data_values->button_one_text) }}
                            </a>
                            <a href="{{ @$bannerContent->data_values->button_two_url }}" class="btn btn-outline--white">
                                {{ __(@$bannerContent->data_values->button_two_text) }}
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

@if (!app()->bound('slick_assets'))
    @php
        app()->instance('slick_assets', true);
    @endphp

    @push('style-lib')
        <link href="{{ asset($activeTemplateTrue . 'css/slick.css') }}" rel="stylesheet">
    @endpush

    @push('script-lib')
        <script src="{{ asset($activeTemplateTrue . 'js/slick.min.js') }}"></script>
    @endpush
@endif
