@php
    $storyContent = getContent('blog.content', true);
    $stories = App\Models\SuccessStory::orderBy('id', 'DESC')->limit(3)->get();
@endphp

<section class="blog my-120">
    <div class="blog-overlay">
        <img src="{{ frontendImage('blog', @$storyContent->data_values->background_image, '1900x960') }}" alt="image">
    </div>
    <div class="container">
        <div class="section-heading">
            <div class="section-heading__name">
                <div class="hand-love-icon ">
                    <span class="icon-hand"><span class="icon-g1135"></span></span>
                    <span class="icon-love"><i class="fa-regular fa-heart"></i></span>
                </div>
                <span class="text">{{ __(@$storyContent->data_values->title) }}</span>
                <div class="hand-love-icon style-two">
                    <span class="icon-hand"><span class="icon-g1135"></span></span>
                    <span class="icon-love"><i class="fa-regular fa-heart"></i></span>
                </div>
            </div>
            <h2 class="section-heading__title">{{ __(@$storyContent->data_values->heading) }}</h2>
            <p class="section-heading__desc">{{ __(@$storyContent->data_values->subheading) }}</p>
        </div>
        <div class="row gy-4 justify-content-center">
            @forelse($stories as $story)
                <div class="col-lg-4 col-md-6">
                    <div class="blog-item card custom--card bg-white card-style-two">
                        @include('Template::success_story.story')
                    </div>
                </div>
            @empty
                <div class="text-center py-3">
                    @include($activeTemplate . 'partials.empty', [
                        'message' => 'Story not found!',
                    ])
                </div>
            @endforelse
        </div>
    </div>
</section>
