@php
    $content = getContent('campaign_category.content', true);
    $categories = App\Models\Category::active()
        ->orderBy('id', 'DESC')
        ->withCount([
            'campaigns' => function ($query) {
                $query->active()->running()->boundary();
            },
        ])
        ->get();
@endphp

@if ($categories->count())
    <div class="cate pb-120">
        <div class="container">
            <div class="row gy-4 justify-content-center">
                <div class="col-lg-6">
                    <div class="section-header text-center">
                        <h2 class="section-title mb-0">{{ __(@$content->data_values->heading) }}</h2>
                    </div>
                </div>
                <div class="col-12">
                    <div class="banner-slider">
                        <div class="container">
                            <div class="justify-content-center">
                                <div class="cate-slider position-relative">
                                    @foreach ($categories as $category)
                                        <div class="category-card-item position-relative has-link hover--effect-1 js-tilt {{ $loop->iteration % 3 == 0 ? 'overlay--three' : ($loop->odd ? 'overlay--one' : 'overlay--two') }}">
                                            <a class="item-link" href="{{ route('campaign.index', ['category' => $category->slug]) }}"></a>
                                            <div class="category-card-item__thumb">
                                                <img class="w-100 __abc" src="{{ getImage(getFilePath('category') . '/' . $category->image, getFileSize('category')) }}" alt="NGO">
                                            </div>
                                            <div class="category-card-item__content">
                                                <h4 class="title text-white">{{ __($category->name) }}
                                                    @if ($category->campaigns_count)
                                                        ({{ $category->campaigns_count }})
                                                    @endif
                                                </h4>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endif
