@php
    $clientContent = getContent('client.content', true);
    $clientElements = getContent('client.element', orderById: true, limit: 9);
@endphp

<div class="client my-120 ">
    <div class="container">
        <div class="row gy-4">
            <div class="col-lg-5">
                <div class="section-heading style-left style-two">
                    <div class="section-heading__name">
                        <div class="hand-love-icon ">
                            <span class="icon-hand"><span class="icon-g1135"></span></span>
                            <span class="icon-love"><i class="fa-regular fa-heart"></i></span>
                        </div>
                        <span class="text">{{ __(@$clientContent->data_values->title) }}</span>
                    </div>
                    <h2 class="section-heading__title">{{ __(@$clientContent->data_values->heading) }}</h2>
                </div>
                <div class="donation-count">
                    <div class="donation-count__list">
                        <h3 class="donation-count__number text--base">{{ @$clientContent->data_values->total_campaign }}
                        </h3>
                        <span class="donation-count__text">@lang('Total Campaigns')</span>
                    </div>
                    <div class="donation-count__list">
                        <h3 class="donation-count__number text--base">
                            {{ @$clientContent->data_values->total_volunteer }}</h3>
                        <span class="donation-count__text">@lang('Volunteers')</span>
                    </div>
                    <div class="donation-count__list">
                        <h3 class="donation-count__number text--base">
                            {{ @$clientContent->data_values->total_countries }}</h3>
                        <span class="donation-count__text">@lang('Countries')</span>
                    </div>
                    <div class="donation-count__list">
                        <h3 class="donation-count__number text--base">
                            {{ @$clientContent->data_values->total_life_impacted }}</h3>
                        <span class="donation-count__text">@lang('Lives Impacted')</span>
                    </div>
                </div>
                <a href="{{ @$clientContent->data_values->button_one_url }}" class="btn btn--base">{{ @$clientContent->data_values->button_one_text }}</a>
            </div>
            <div class="col-lg-1">
                <div class="h-100 text-center"><span class="client-line"></span></div>
            </div>
            <div class="col-lg-6 align-self-center">
                <p class="client--heading"> {{ __(@$clientContent->data_values->client_heading) }} </p>
                <div class="client-logos">
                    @foreach ($clientElements as $clientElement)
                        <div class="client-logo">
                            <img src="{{ frontendImage('client', @$clientElement->data_values->image, '140x35') }}" alt="img">
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
