@php
    $content = getContent('donation_cta.content', true);
@endphp

<section class="donation-cta-section">
    <div class="container">
        <form action="{{ route('campaign.donation.process') }}" method="POST" class="disableSubmission rise-form">
            @csrf
            <input name="anonymous" type="hidden" value="1" checked>
            <div class="donation-cta__inner">
                <h4 class="donation-cta__title">{{ __(@$content->data_values->heading) }}</h4>
                <div class="donation-cta__content flex-align ">
                    <div class="flex-fill donation-cta__input">
                        <select name="campaign_id" class="donation-cta__select campaign-select custom--select2" required>
                            <option value="" selected>@lang('Select Campaign')</option>
                        </select>
                    </div>
                    <div class="flex-fill donation-cta__input">
                        <div class="donation-cta__input input--group input-group w-100">
                            <input type="number" name="amount" value="{{ old('amount') }}" class="form-control form--control bg-white" required placeholder="@lang('Donate Amount')">
                            <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                        </div>
                    </div>
                    <button class="btn btn--base donation-cta__btn" type="submit">@lang('Donate Now')</button>
                </div>
            </div>
        </form>
    </div>
</section>

@push('style')
    <style>
        .custom--select2+.select2-container {
            background-color: hsl(var(--white));
        }

        .custom--select2+.select2-container .select2-selection__arrow {
            background-color: hsl(var(--white));
        }
    </style>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";

            $(".campaign-select").select2({
                placeholder: "@lang('Select Campaign')",
                allowClear: true,
                ajax: {
                    url: "{{ route('campaign.donation.eligible') }}",
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            search: params.term,
                            page: params.page
                        };
                    },
                    processResults: function(data, params) {
                        params.page = params.page || 1;
                        console.log(data);

                        return {
                            results: data.items,
                            pagination: {
                                more: data.has_more
                            }
                        };
                    },
                    cache: true
                },
                templateResult: formatRepo,
                templateSelection: formatRepoSelection
            });

            function formatRepo(repo) {
                if (repo.loading) {
                    return repo.text;
                }

                var $container = $(
                    "<div class='select2-result-repository clearfix'>" +
                    "<div class='select2-result-repository__title'></div>" +
                    "<div class='select2-result-repository__description goal'></div>" +
                    "<div class='select2-result-repository__description raised'></div>" +
                    "</div>"
                );

                $container.find(".select2-result-repository__title").text(repo.title);
                $container.find(".goal").text("@lang('Goal:') " + repo.goal);
                $container.find(".raised").append("@lang('Raised:') " + repo.raised);
                return $container;
            }

            function formatRepoSelection(data) {
                return data.title || "@lang('Select Campaign')";
            }

        })(jQuery);
    </script>
@endpush
