@php
    $faqContent = getContent('faq.content', true);
    $faqElements = getContent('faq.element', orderById: true, limit: 3);
@endphp

<section class="faq-section py-120">
    <div class="faq-section__overlay">
        <img class="handshake-love" src="{{ frontendImage('faq', @$faqContent->data_values->background_left, '190x105') }}" alt="left_bg">
        <img class="hand-love" src="{{ frontendImage('faq', @$faqContent->data_values->background_right, '66x66') }}" alt="right_bg">
    </div>
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <div class="faq-video">
                    <a class="popup-video play-video" href="{{ @$faqContent->data_values->video_url }}">
                        <i class="icon-play-button-1-1"></i>
                    </a>
                    <div class="faq-video-thumb">
                        <img src="{{ frontendImage('faq', @$faqContent->data_values->background_image, '635x530') }}" alt="faq_bg">
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="section-heading style-left">
                    <div class="section-heading__name">
                        <div class="hand-love-icon ">
                            <span class="icon-hand"><span class="icon-g1135"></span></span>
                            <span class="icon-love"><i class="fa-regular fa-heart"></i></span>
                        </div>
                        <span class="text">{{ __(@$faqContent->data_values->title) }}</span>
                    </div>
                    <h2 class="section-heading__title">{{ __(@$faqContent->data_values->heading) }}</h2>
                    <p class="section-heading__desc">{{ __(@$faqContent->data_values->subheading) }}</p>
                </div>
                <div class="faq--accordion">
                    <div class="accordion custom--accordion" id="accordionExample">
                        @foreach ($faqElements as $key => $faqElement)
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne{{ $key }}" aria-expanded="false" aria-controls="collapseOne">
                                        {{ __(@$faqElement->data_values->question) }}
                                    </button>
                                </h2>
                                <div id="collapseOne{{ $key }}" class="accordion-collapse collapse " data-bs-parent="#accordionExample">
                                    <div class="accordion-body">{{ __(@$faqElement->data_values->answer) }}</div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

@push('style-lib')
    <link href="{{ asset($activeTemplateTrue . 'css/magnific-popup.min.css') }}" rel="stylesheet">
@endpush

@push('script-lib')
    <script src="{{ asset($activeTemplateTrue . 'js/jquery.magnific-popup.min.js') }}"></script>
@endpush
