@php
    $featureContent = getContent('feature.content', true);
    $featureElements = getContent('feature.element', orderById: true, limit: 4);
@endphp

<section class="feature-section my-120">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <div class="section-heading style-left">
                    <div class="section-heading__name">
                        <div class="hand-love-icon ">
                            <span class="icon-hand"><span class="icon-g1135"></span></span>
                            <span class="icon-love"><i class="fa-regular fa-heart"></i></span>
                        </div>
                        <span class="text">{{ __(@$featureContent->data_values->title) }}</span>
                    </div>
                    <h2 class="section-heading__title">{{ __(@$featureContent->data_values->heading) }}</h2>
                    <p class="section-heading__desc">{{ __(@$featureContent->data_values->subheading) }}</p>
                </div>
                <div class="feature-section__btn-group">
                    <a href="{{ @$featureContent->data_values->button_one_url }}" class="btn btn--base">{{ __(@$featureContent->data_values->button_one_text) }}</a>
                    <a href="{{ @$featureContent->data_values->button_one_url }}" class="btn btn-outline--base">{{ __(@$featureContent->data_values->button_two_text) }}</a>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="row mt-2 gy-4">
                    @foreach ($featureElements as $featureElement)
                        <div class="col-sm-6 col-xsm-6">
                            <div class="feature-card">
                                <div class="feature-card__icon">@php echo @$featureElement->data_values->icon @endphp
                                </div>
                                <div class="feature-card__content">
                                    <h5 class="feature-card__title">{{ __(@$featureElement->data_values->heading) }}
                                    </h5>
                                    <p class="feature-card__desc">{{ __(@$featureElement->data_values->subheading) }}
                                    </p>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</section>
