@php
    $content = getContent('recently_funded_campaign.content', true);

    $campaigns = App\Models\Campaign::whereHas('donations')
        ->with([
            'user.organization',
            'category',
            'donations' => function ($q) {
                $q->paid();
            },
        ])
        ->running()
        ->where(function ($query) {
            $query
                ->where(function ($q) {
                    $q->where('goal_type', Status::AFTER_DEADLINE)->whereDate('deadline', '>', now());
                })
                ->orWhere(function ($q) {
                    $q->where('goal_type', Status::GOAL_ACHIEVE)->whereHas('donations', function ($subQuery) {
                        $subQuery->select(DB::raw('SUM(donation) as total_donations'))->groupBy('campaign_id')->havingRaw('total_donations <= goal');
                    });
                })
                ->orWhere('goal_type', Status::CONTINUOUS);
        })
        ->withCount([
            'donations as total_donations' => function ($query) {
                $query->select(DB::raw('SUM(donation)'));
            },
        ])
        ->addSelect(['latest_donation_at' => App\Models\Donation::select('created_at')->whereColumn('campaign_id', 'campaigns.id')->latest()->limit(1)])
        ->orderBy('latest_donation_at', 'desc')
        ->groupBy('campaigns.id')
        ->take(3)
        ->get();
@endphp

<section class="campaign-section py-120 section-bg">
    <div class="campaign-section__overlay">
        <img src="{{ frontendImage('recently_funded_campaign', @$content->data_values->background_image, '240x280') }}" alt="img">
    </div>
    <div class="container">
        <div class="row gy-2">
            <div class="col-lg-6">
                <div class="section-heading style-left">
                    <div class="section-heading__name">
                        <div class="hand-love-icon ">
                            <span class="icon-hand"><span class="icon-g1135"></span></span>
                            <span class="icon-love"><i class="fa-regular fa-heart"></i></span>
                        </div>
                        <span class="text">{{ __(@$content->data_values->title) }}</span>
                    </div>
                    <h2 class="section-heading__title">{{ __(@$content->data_values->heading) }}</h2>
                    <p class="section-heading__desc">{{ __(@$content->data_values->short_description) }}</p>
                </div>
            </div>
            <div class="col-lg-6 text-lg-end">
                <a href="{{ route('campaign.index') }}" class="btn btn--base">
                    @lang('See all Campaign')
                </a>
            </div>
        </div>
        <div class="row gy-4 mt-2">

            @if ($campaigns->count())
                @include('Template::campaign.campaign', ['class' => 'col-lg-4 col-md-6'])
            @else
                <div class="text-center py-3">
                    @include($activeTemplate . 'partials.empty', ['message' => 'Campaign not found!'])
                </div>
            @endif
        </div>
    </div>
</section>
