@php
    $teamContent = getContent('team.content', true);
    $teamElements = getContent('team.element', orderById: true);
    $volunteers = App\Models\Volunteer::active()->latest()->limit(4)->get();
@endphp

<section class="team-section my-120">
    <div class="container">
        <div class="section-heading">
            <div class="section-heading__name">
                <div class="hand-love-icon ">
                    <span class="icon-hand"><span class="icon-g1135"></span></span>
                    <span class="icon-love"><i class="fa-regular fa-heart"></i></span>
                </div>
                <span class="text">{{ __(@$teamContent->data_values->title) }}</span>
                <div class="hand-love-icon style-two">
                    <span class="icon-hand"><span class="icon-g1135"></span></span>
                    <span class="icon-love"><i class="fa-regular fa-heart"></i></span>
                </div>
            </div>
            <h2 class="section-heading__title">{{ __(@$teamContent->data_values->heading) }}</h2>
            <p class="section-heading__desc">{{ __(@$teamContent->data_values->subheading) }}</p>
        </div>
        <div class="row gy-4">
            @forelse($volunteers as $volunteer)
                <div class="col-lg-3 col-sm-6 col-xsm-6">
                    <div class="team-card">
                        <div class="team-card__thumb">
                            <img class="fit-image" src="{{ getImage(getFilePath('volunteer') . '/' . $volunteer->image, getFileSize('volunteer')) }}" alt="img">
                        </div>
                        <div class="team-card__context">
                            <h6 class="team-card__name">{{ __($volunteer->fullname) }}</h6>
                            <p class="p team-card__designation">@lang("Participated {$volunteer->participated} Campaigns")</p>
                            <p class="designation"><strong class="text--base"> @lang('From')</strong> :
                                {{ __(@$volunteer->country) }}</p>
                        </div>
                    </div>
                </div>
            @empty
                <div class="text-center py-3">
                    @include($activeTemplate . 'partials.empty', ['message' => 'Volunteer not found!'])
                </div>
            @endforelse
        </div>
    </div>
</section>
