@php
    $testimonialContent = getContent('testimonials.content', true);
    $testimonialElements = getContent('testimonials.element');
@endphp

<section class="testimonials-section py-120">
    <div class="testimonials--overlay">
        <span class="img-left">
            <img src="{{ frontendImage('testimonials', @$testimonialContent->data_values->background_left,'755x1120') }}"
                alt="testimonial left">
        </span>
        <span class="img-right">
            <img src="{{ frontendImage('testimonials', @$testimonialContent->data_values->background_right,'745x1115') }}"
                alt="testimonial right">
        </span>
    </div>
    <div class="container">
        <div class="row">
            <div class="col-xl-5">
                <div class="testimonials-section__thumb">
                    <img class="img-fluid w-100"
                        src="{{ frontendImage('testimonials', @$testimonialContent->data_values->thumb,'525x495') }}"
                        alt="testimonial thumb">
                </div>
            </div>
            <div class="col-xl-7">
                <div class="section-heading style-left style-two">
                    <div class="section-heading__name">
                        <div class="hand-love-icon ">
                            <span class="icon-hand"><span class="icon-g1135"></span></span>
                            <span class="icon-love"><i class="fa-regular fa-heart"></i></span>
                        </div>
                        <span class="text">{{ __(@$testimonialContent->data_values->heading) }}</span>
                    </div>
                    <h2 class="section-heading__title">{{ __(@$testimonialContent->data_values->subheading) }}</h2>
                </div>
                <div class="testimonial-card--list ">
                    @foreach ($testimonialElements as $testimonialElement)
                        <div class="testimonial-card">
                            <div class="testimonial-card__icon"><i class="icon-straight-quotes-2-1"></i></div>
                            <p class="testimonial-card__text">{{ __(@$testimonialElement->data_values->story_text) }}
                            </p>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</section>

@if (!app()->bound('slick_assets'))
    @php
        app()->instance('slick_assets', true);
    @endphp

    @push('style-lib')
        <link href="{{ asset($activeTemplateTrue . 'css/slick.css') }}" rel="stylesheet">
    @endpush

    @push('script-lib')
        <script src="{{ asset($activeTemplateTrue . 'js/slick.min.js') }}"></script>
    @endpush
@endif
