@php
    $donorContent = getContent('top_donors.content', true);
    $topDonors = App\Models\Donation::paid()->groupBy('email')->selectRaw('*,sum(donation) as totalDonations')->orderBy('totalDonations', 'DESC')->limit(12)->get();
@endphp

<section class="donors-section my-120">
    <div class="donors-overlay">
        <img src="{{ frontendImage('top_donors', @$donorContent->data_values->background_image, '1670x665') }}" alt="image">
    </div>
    <div class="row">
        <div class="col-12">
            <div class="section-heading">
                <div class="section-heading__name">
                    <div class="hand-love-icon ">
                        <span class="icon-hand"><span class="icon-g1135"></span></span>
                        <span class="icon-love"><i class="fa-regular fa-heart"></i></span>
                    </div>
                    <span class="text">{{ __(@$donorContent->data_values->title) }}</span>
                    <div class="hand-love-icon style-two">
                        <span class="icon-hand"><span class="icon-g1135"></span></span>
                        <span class="icon-love"><i class="fa-regular fa-heart"></i></span>
                    </div>
                </div>
                <h2 class="section-heading__title">{{ __(@$donorContent->data_values->heading) }}</h2>
                <p class="section-heading__desc">{{ __(@$donorContent->data_values->subheading) }}</p>
            </div>
        </div>
    </div>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-10 col-lg-12">
                <div class="template-table">
                    @if ($topDonors->count())
                        <div class="row justify-content-center gy-4">
                            @foreach ($topDonors as $key => $topDonor)
                                <div class="col-xl-4 col-sm-6 col-xsm-6">
                                    <div class="top-donor-item">
                                        <h3 class="top-donor-item__position"> <span class="text">{{ ordinal($key + 1) }}</span> </h3>
                                        <div class="top-donor-item__content">
                                            <h5 class="top-donor-item__name"> {{ $topDonor->fullname }} </h5>
                                            <h5 class="top-donor-item__amount mb-0 text--base">@lang('Donation'): {{ showAmount($topDonor->totalDonations) }} </h5>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-3">
                            @include($activeTemplate . 'partials.empty', [
                                'message' => 'Donors not found!',
                            ])
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</section>
