@php
    $visionContent = getContent('vision.content', true);
    $visionElements = getContent('vision.element', orderById: true, limit: 4);
@endphp

<section class="vision-mission-section py-120">
    <div class="container">
        <div class="row gy-4 justify-content-between">
            <div class="col-lg-6">
                <div class="section-heading style-left mb-2 md-md-4">
                    <div class="section-heading__name">
                        <div class="hand-love-icon ">
                            <span class="icon-hand"><span class="icon-g1135"></span></span>
                            <span class="icon-love"><i class="fa-regular fa-heart"></i></span>
                        </div>
                        <span class="text">{{ __(@$visionContent->data_values->title) }}</span>
                    </div>
                    <h2 class="section-heading__title mb-0">{{ __(@$visionContent->data_values->heading) }}</h2>
                </div>
                <p class="vision-mission__desc">
                    {{ __(@$visionContent->data_values->description) }}
                </p>
                <div class="vision-mission__list">
                    @foreach ($visionElements as $visionElement)
                        <div class="vision-mission__item">
                            <span class="icon text--base me-2"> <i class="fa-regular fa-circle-check"></i> </span>
                            <span class="text">{{ __(@$visionElement->data_values->vision) }}</span>
                        </div>
                    @endforeach
                </div>
            </div>
            <div class="col-lg-5">
                <div class="vision-mission__thumb">
                    <img class="img-fluid w-100" src="{{ frontendImage('vision', @$visionContent->data_values->image,'525x440') }}"
                        alt="img">
                </div>
            </div>
        </div>
        
    </div>
</section>