@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <section class="blog-detials py-120 section--bg">
        <div class="container">
            <div class="row gy-5 justify-content-center">
                <div class="col-xl-9 col-lg-8">
                    <div class="blog-details">
                        <div class="blog-details__thumb">
                            <img src="{{ getImage(getFilePath('success') . '/' . $story->image, getFileSize('success')) }}" class="fit-image" alt="img">
                        </div>
                        <div class="blog-details__content">
                            <span class="blog-item__date mb-2"><span class="blog-item__date-icon"><i class="las la-clock"></i></span>{{ showDateTime($story->created_at, 'd M Y') }}</span>
                            <h3 class="blog-details__title"> {{ __($story->title) }} </h3>
                            <p class="blog-details__desc">@php echo strip_tags($story->description) @endphp</p>

                            <div class="blog-details__share mt-4 d-flex align-items-center flex-wrap">
                                <h5 class="social-share__title mb-0 me-sm-3 me-1 d-inline-block">@lang('Share This')</h5>
                                <ul class="social-list">
                                    <li class="social-list__item"><a href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode(url()->current()) }}" class="social-list__link flex-center" target="_blank"><i class="fab fa-facebook-f"></i></a>
                                    </li>
                                    <li class="social-list__item"><a href="https://twitter.com/intent/tweet?url={{ urlencode(url()->current()) }}&text={{ urlencode($story->title) }}" class="social-list__link flex-center" target="_blank"> <i class="fab fa-twitter"></i></a>
                                    </li>
                                    <li class="social-list__item"><a href="https://www.linkedin.com/shareArticle?mini=true&url={{ urlencode(url()->current()) }}&title={{ urlencode($story->title) }}" class="social-list__link flex-center" target="_blank"> <i class="fab fa-linkedin-in"></i></a>
                                    </li>
                                    <li class="social-list__item"><a href="https://pinterest.com/pin/create/button/?url={{ urlencode(url()->current()) }}&media={{ urlencode(getImage(getFilePath('success') . '/' . $story->image)) }}&description={{ urlencode($story->title) }}" class="social-list__link flex-center" target="_blank"> <i class="fab fa-pinterest"></i></a>
                                    </li>
                                </ul>
                            </div>
                            <div class="fb-comments" data-href="{{ url()->current() }}" data-numposts="5"></div>
                        </div>
                        <!-- Comments Form Start -->
                        <div class="contact-form pt-2" id="comment-box">
                            <h3 class="contact__title"> @lang('Leave a Comment') </h3>
                            <form action="{{ route('success.story.comment', $story->id) }}" method="POST" autocomplete="off">
                                @csrf
                                <div class="row">
                                    <div class="col-sm-6">
                                        <input type="text" name="name" value="{{ old('name') }}" class="form--control" placeholder="@lang('Enter Your Name')" required>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <input type="email" name="email" value="{{ old('email') }}" class="form--control" placeholder="@lang('Enter Email Address')" required>
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <textarea class="form--control" name="comment" placeholder="@lang('Write Comment Here..')" required>{{ old('comment') }}</textarea>
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <button class="btn btn--base"> @lang('Submit') </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <!-- Comment Form End -->

                        <!-- Comments Start -->
                        @php
                            $totalComment = \App\Models\StoryComment::where('success_story_id', $story->id)->published()->count();
                        @endphp

                        <div class="col-lg-12 pt-5">
                            <h5 class="details-subtitle mb-4">{{ $totalComment }} @lang('COMMENTS')</h5>
                            <ul class="comment-list comment-lists">
                                @forelse($comments as $comment)
                                    <li class="comment-list__item d-flex flex-wrap">
                                        <div class="comment-list__content">
                                            <h5 class="comment-list__name">{{ __($comment->commenter) }}</h5>
                                            <span class="comment-list__time">
                                                <span class="comment-list__time-icon"><i class="far fa-clock"></i></span>
                                                {{ diffForHumans($comment->created_at) }}
                                            </span>
                                            <p class="comment-list__desc">{{ __($comment->comment) }}</p>
                                        </div>
                                    </li>
                                @empty
                                    @include($activeTemplate . 'partials.empty', [
                                        'message' => 'No comment found!',
                                    ])
                                @endforelse
                            </ul>
                            @if (@$comments->hasMorePages())
                                <div class="text-center mt-4">
                                    <button class="btn btn--base load-more-comments" data-page="{{ @$comments->currentPage() + 1 }}">
                                        @lang('Load More')
                                    </button>
                                </div>
                            @endif
                        </div>
                        <!-- Comments End -->
                    </div>
                </div>
                <div class="col-xl-3 col-lg-4">
                    <div class="blog-sidebar-wrapper">
                        <div class="blog-sidebar">
                            <h5 class="blog-sidebar__title"> @lang('Latest Stories') </h5>
                            @foreach ($recentStories as $item)
                                <div class="latest-blog">
                                    <div class="latest-blog__thumb">
                                        <a href="{{ route('success.story.details', $item->slug) }}">
                                            <img src="{{ getImage(getFilePath('success') . '/thumb_' . $item->image, getThumbSize('success')) }}" class="fit-image" alt="img"></a>
                                    </div>
                                    <div class="latest-blog__content">
                                        <h6 class="latest-blog__title"><a href="{{ route('success.story.details', $item->slug) }}">{{ strLimit($item->title, 50) }}</a>
                                        </h6>
                                        <span class="latest-blog__date fs-13">{{ showDateTime(@$item->created_at, 'd M Y') }}</span>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('fbComment')
    @php echo loadExtension('fb-comment') @endphp
@endpush

@push('script')
    <script>
        "use strict";
        (function($) {
            $(document).on('click', '.load-more-comments', function() {
                let button = $(this);
                let nextPage = button.data('page');
                let successStoryId = {{ $story->id }};

                $.ajax({
                    url: "{{ route('success.story.comments.loadMore') }}?page=" + nextPage,
                    type: "GET",
                    data: {
                        successStoryId: successStoryId
                    },
                    beforeSend: function() {
                        button.text('@lang('Loading...')').prop('disabled', true);
                    },
                    success: function(response) {
                        if (response.html) {
                            $('.comment-lists').append(response.html);
                            if (response.hasMore) {
                                button.data('page', nextPage + 1).text('@lang('Load More')').prop(
                                    'disabled', false);
                            } else {
                                button.remove();
                            }
                        } else {
                            button.remove();
                        }
                    },
                    error: function() {
                        button.text('@lang('Load More')').prop('disabled', false);
                        alert('@lang('Something went wrong. Please try again.')');
                    }
                });
            });
        })(jQuery);
    </script>
@endpush
