@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <main class="blog-page">
        <section class="blog my-120">
            <div class="container">
                <div class="row">
                    <div class="col-xl-3">
                        <!--==========================   Campaign-sidebar Start  ==========================-->
                        <div class="campaign-sidebar offcanvas-xl offcanvas-end" tabindex="-1" id="campaignSidebar"
                            aria-labelledby="campaignSidebarLabel">
                            <span class="offcanvas--close" data-bs-dismiss="offcanvas" data-bs-target="#campaignSidebar"
                                aria-label="Close"><i class="fa-solid fa-angles-right"></i></span>
                            <div class="campaign-sidebar__inner">
                                <div class="sidebar-card search-card d-none d-xl-block">
                                    <h5 class="sidebar-card__title">@lang('Filter by search')</h5>
                                    <div class="sidebar-card__content">
                                        <form class="no-submit-loader" method="GET"
                                            action="{{ route('success.story.archive') }}">
                                            <div class="form-group">
                                                <div class="input-group input--group">
                                                    <input type="text" name="search" class="form-control form--control"
                                                        placeholder="@lang('Search By Title...')" value="{{ request()->search }}" />
                                                    <button type="submit" class="input-group-text name-search"><i
                                                            class="fa fa-search"></i></button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <div class="sidebar-card category-card">
                                    <h5 class="sidebar-card__title">@lang('Categories')</h5>
                                    <div class="sidebar-card__content">
                                        <ul class="category-card__list">
                                            @foreach ($categories as $category)
                                                <li>
                                                    <a class="category-card__item campaign-category @if ($category->slug == request()->slug) active @endif"
                                                        href="{{ route('success.story.archive', ['slug' => $category->slug]) }}">
                                                        <span class="icon"><i class="fa-solid fa-angles-right"></i></span>
                                                        {{ __($category->name) }}
                                                    </a>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                                @if (!blank($archives))
                                    <div class="sidebar-card category-card mb-3">
                                        <h5 class="sidebar-card__title">@lang('Archive')</h5>
                                        <div class="sidebar-card__content">
                                            <ul class="category-card__list">
                                                @foreach ($archives as $archive)
                                                    <li>
                                                        <a class="category-card__item campaign-category @if ($archive->month == request()->month && $archive->year == request()->year) active @endif"
                                                            href="{{ route('success.story.archive', ['month' => $archive->month, 'year' => $archive->year]) }}">
                                                            <span class="icon"><i class="fa fa-archive"></i></span>
                                                            {{ __($archive->month) }} {{ __($archive->year) }}
                                                        </a>
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                        <!--==========================  Campaign-sidebar End  ==========================-->
                    </div>

                    <div class="col-xl-9">
                        <div class="row gy-4">
                            <div class="col-12 d-block d-xl-none text-end">
                                <div class="mobile-filter flex-between">
                                    <form class="input-group input--group" method="GET"
                                        action="{{ route('success.story.archive') }}">
                                        <input type="search" class="form-control form--control" name="search"
                                            placeholder="@lang('Search Story')">
                                        <button type="submit" class="input-group-text"><i
                                                class="fa fa-search"></i></button>
                                    </form>

                                    <button class="filter-button" type="button" data-bs-toggle="offcanvas"
                                        data-bs-target="#campaignSidebar" aria-controls="campaignSidebar">
                                        <span id="hiddenNav"><i class="las la-filter"></i></span>
                                    </button>
                                </div>
                            </div>
                            <div class="col-12">
                                @if (!blank($stories))
                                    <div class="row gy-4 justify-content-center">
                                        @foreach ($stories as $story)
                                            <div class="col-md-6">
                                                <div class="blog-item card custom--card">
                                                    @include('Template::success_story.story')
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                    @if ($stories->hasPages())
                                        {{ paginateLinks($stories) }}
                                    @endif
                                @else
                                    <div class="text-center">
                                        <div class="card custom--card  dashboard-sidebar overflow-y-auto">
                                            @include($activeTemplate . 'partials.empty', [
                                                'message' => ucfirst(strtolower($pageTitle)) . ' not found!',
                                            ])
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </section>

        @if (@$sections->secs != null)
            @foreach (json_decode($sections->secs) as $sec)
                @include($activeTemplate . 'sections.' . $sec)
            @endforeach
        @endif
    </main>
@endsection
