@php
    $loginContent = getContent('auth.content', true);
    $loginElements = getContent('auth.element');
@endphp

@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <main class="registration-page">
        @include('Template::partials.breadcrumb')
        <section class="account py-120 bg-img"
            data-background-image="{{ frontendImage('auth', @$loginContent->data_values->background_image, '1930x1150') }}">
            <div class="account-overlay">
                <div class="account-overlay__play">
                    <img src="{{ frontendImage('auth', @$loginContent->data_values->animation_image_one, '73x72') }}"
                        alt="img">
                </div>
                <div class="account-overlay__charity">
                    <img src="{{ frontendImage('auth', @$loginContent->data_values->animation_image_two, '65x65') }}"
                        alt="img">
                </div>
                <div class="account-overlay__top">
                    <img class="thumb"
                        src="{{ frontendImage('auth', @$loginContent->data_values->background_top, '565x375') }}"
                        alt="img">
                </div>
                <div class="account-overlay__bottom">
                    <img class="thumb"
                        src="{{ frontendImage('auth', @$loginContent->data_values->background_bottom, '550x380') }}"
                        alt="img">
                </div>
            </div>
            <div class="account-inner">
                <div class="container">
                    <div class="row gy-4 justify-content-center">
                        <div class=" col-lg-6">
                            <div class="account-form">
                                <div class="account-form__inner">
                                    <div class="account-form__content mb-4">
                                        <h3 class="account-form__title"> {{ __(@$loginContent->data_values->heading) }}
                                        </h3>
                                        <p class="account-form__desc">{{ __(@$loginContent->data_values->subheading) }}</p>
                                    </div>
                                    @include($activeTemplate . 'partials.social_login')
                                    <form class="verify-gcaptcha disableSubmission" action="{{ route('user.login') }}"
                                        method="POST">
                                        @csrf
                                        <div class="row">
                                            <div class="col-12 form-group">
                                                <div class="form--group">
                                                    <label class="form--label">@lang('Username')</label>
                                                    <input type="text" class="form--control" name="username"
                                                        value="{{ old('username') }}" required>
                                                </div>
                                            </div>
                                            <div class="col-12 form-group">
                                                <label class="form--label">@lang('Password')</label>
                                                <div class="position-relative mb-2">
                                                    <input type="password" class="form-control form--control password-input"
                                                        name="password" required>
                                                    <span class="password-show-hide fas fa-eye toggle-password fa-eye-slash"
                                                        data-password-element="password-input" id="your-password"></span>
                                                </div>
                                                <a class="text--base" href="{{ route('user.password.request') }}">
                                                    @lang('Forgot your password?')
                                                </a>
                                            </div>

                                            <x-captcha />

                                            <div class="col-12 form-group">
                                                <button type="submit"
                                                    class="btn btn--base w-100">@lang('Sign In')</button>
                                            </div>
                                            <div class="col-12">
                                                <div class="have-account">
                                                    <p class="have-account__text">@lang('Don\'t have an account?') <a
                                                            href="{{ route('user.register') }}"
                                                            class="have-account__link text--base">@lang('Signup Now')</a></p>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>
@endsection

@push('style')
    <style>
        .banner-section__layer {
            --banner-shape: url({{ frontendImage('auth', @$loginContent->data_values->background_image, '1930x1150') }});
        }
    </style>
@endpush
