@php
    $loginContent = getContent('auth.content', true);
    $loginElements = getContent('auth.element');
@endphp

@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <main class="registration-page">
        @include('Template::partials.breadcrumb')
        <section class="account py-120 bg-img" data-background-image="{{ frontendImage('auth', @$loginContent->data_values->background_image, '1930x1150') }}">
            @if (gs('registration'))
                <div class="account-overlay">
                    <div class="account-overlay__play">
                        <img src="{{ frontendImage('auth', @$loginContent->data_values->animation_image_one, '73x72') }}" alt="img">
                    </div>
                    <div class="account-overlay__charity">
                        <img src="{{ frontendImage('auth', @$loginContent->data_values->animation_image_two, '65x65') }}" alt="img">
                    </div>
                    <div class="account-overlay__top">
                        <img class="thumb" src="{{ frontendImage('auth', @$loginContent->data_values->background_top, '565x375') }}" alt="img">
                    </div>
                    <div class="account-overlay__bottom">
                        <img class="thumb" src="{{ frontendImage('auth', @$loginContent->data_values->background_bottom, '550x380') }}" alt="img">
                    </div>
                </div>
                <div class="account-inner">
                    <div class="container">
                        <div class="row gy-4 justify-content-center">
                            <div class=" col-lg-6">
                                <div class="account-form">
                                    <div class="account-form__inner">
                                        <div class="account-form__content mb-4">
                                            <h3 class="account-form__title">{{ __(@$loginContent->data_values->heading) }}
                                            </h3>
                                            <p class="account-form__desc">{{ __(@$loginContent->data_values->subheading) }}
                                            </p>
                                        </div>

                                        @include($activeTemplate . 'partials.social_login')

                                        <form class="verify-gcaptcha disableSubmission" action="{{ route('user.register') }}" method="POST">
                                            @csrf
                                            <div class="row">
                                                @if (session()->get('reference') != null)
                                                    <div class="col-12 mb-3">
                                                        <p>@lang('You\'re referred by') <i class="fw-bold text--base">{{ session()->get('reference') }}</i></p>
                                                    </div>
                                                @endif
                                                <div class="col-sm-6 form-group">
                                                    <div class="form--group">
                                                        <label class="form--label">@lang('First Name')</label>
                                                        <input type="text" name="firstname" class="form--control" value="{{ old('firstname') }}" required>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 form-group">
                                                    <div class="form--group">
                                                        <label class="form--label">@lang('Last Name')</label>
                                                        <input type="text" name="lastname" class="form--control" value="{{ old('lastname') }}" required>
                                                    </div>
                                                </div>
                                                <div class="col-sm-12 form-group">
                                                    <div class="form--group">
                                                        <label class="form--label">@lang('Email Address')</label>
                                                        <input type="email" name="email" class="form--control checkUser" value="{{ old('email') }}" required>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 form-group">
                                                    <label class="form--label">@lang('Password')</label>
                                                    <div class="position-relative">
                                                        <input type="password" class="form-control form--control password-input-one @if (gs('secure_password')) secure-password @endif" name="password" required>
                                                        <span class="password-show-hide fas fa-eye toggle-password fa-eye-slash" data-password-element="password-input-one" id="#your-password"></span>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 form-group">
                                                    <label class="form--label">@lang('Confirm Password')</label>
                                                    <div class="position-relative">
                                                        <input type="password" class="form-control form--control password-input-two" name="password_confirmation" required>
                                                        <div class="password-show-hide fas fa-eye toggle-password fa-eye-slash" data-password-element="password-input-two" id="#confirm-password"></div>
                                                    </div>
                                                </div>

                                                <x-captcha />

                                                @if (gs('agree'))
                                                    @php
                                                        $policyPages = getContent('policy_pages.element', false, orderById: true);
                                                    @endphp
                                                    <div class="form-group">
                                                        <input type="checkbox" id="agree" @checked(old('agree')) name="agree" required>
                                                        <label for="agree">@lang('I agree with')</label> <span>
                                                            @foreach ($policyPages as $policy)
                                                                <a class="text--base" href="{{ route('policy.pages', $policy->slug) }}" target="_blank">{{ __($policy->data_values->title) }}</a>
                                                                @if (!$loop->last)
                                                                    ,
                                                                @endif
                                                            @endforeach
                                                        </span>
                                                    </div>
                                                @endif
                                                <div class="col-sm-12 form-group">
                                                    <button type="submit" class="btn btn--base w-100">@lang('Sign Up')</button>
                                                </div>
                                                <div class="col-sm-12">
                                                    <div class="have-account">
                                                        <p class="have-account__text">@lang('Already Have An Account?') <a href="{{ route('user.login') }}" class="have-account__link text--base">@lang('Login Now')</a>
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @else
                @include($activeTemplate . 'partials.registration_disabled')
            @endif
        </section>
    </main>

    @if (gs('registration'))
        <div class="modal custom--modal fade" id="existModalCenter" role="dialog" aria-labelledby="existModalCenterTitle" aria-hidden="true" tabindex="-1">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="existModalLongTitle">@lang('You are with us')</h5>
                        <span class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                            <i class="las la-times"></i>
                        </span>
                    </div>
                    <div class="modal-body">
                        <h5 class="text-center">@lang('You already have an account please Login ')</h5>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-dark btn-sm" data-bs-dismiss="modal" type="button">@lang('Close')</button>
                        <a class="btn btn--base" href="{{ route('user.login') }}">@lang('Login')</a>
                    </div>
                </div>
            </div>
        </div>
    @endif
@endsection

@if (gs('registration'))

    @if (gs('secure_password'))
        @push('script-lib')
            <script src="{{ asset('assets/global/js/secure_password.js') }}"></script>
        @endpush
        @push('style')
            <style>
                .input-popup P {
                    color: hsl(var(--white)/0.7);
                }
            </style>
        @endpush
    @endif

    @push('script')
        <script>
            "use strict";
            (function($) {

                $('.checkUser').on('focusout', function(e) {
                    var url = '{{ route('user.checkUser') }}';
                    var value = $(this).val();
                    var token = '{{ csrf_token() }}';

                    var data = {
                        email: value,
                        _token: token
                    }

                    $.post(url, data, function(response) {
                        if (response.data != false) {
                            $('#existModalCenter').modal('show');
                        }
                    });
                });
            })(jQuery);
        </script>
    @endpush

@endif
@push('style')
    <style>
        .banner-section__layer {
            --banner-shape: url({{ frontendImage('auth', @$loginContent->data_values->background_image, '1930x1150') }});
        }
    </style>
@endpush
