@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="user-details__content">
        <div class="flex-between gap-2">
            <div class="d-xl-none position-relative z-1 mb-3">
                <button class="btn btn--sm btn-outline--base" type="button" data-bs-toggle="offcanvas"
                    data-bs-target="#offcanvasRight" aria-controls="offcanvasRight">
                    <span class="icon"><i class="fa-solid fa-bars"></i></span>
                    <span class="text">@lang('Menu')</span>
                </button>
            </div>
            @if (!blank($campaigns))
                <form class="header-search-from flex-fill">
                    <div class="input-group style-two mb-2">
                        <input type="search" class="form-control form--control bg-white" name="search"
                            value="{{ request()->search }}" placeholder="@lang('Search by title')">
                        <button class="input-group-text bg--base text-white">
                            <i class="fa-solid fa-magnifying-glass"></i>
                        </button>
                    </div>
                </form>
            @endif
        </div>
        @if (!blank($campaigns))
            <table class="table custom--table table--responsive--md">
                <thead>
                    <tr>
                        <th>@lang('TITLE')</th>
                        <th>@lang('GOAL')</th>
                        <th>@lang('RAISED')</th>
                        <th>@lang('DEADLINE')</th>
                        <th>@lang('STATUS')</th>
                        <th>@lang('ACTIONS')</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($campaigns as $item)
                        @php
                            $donation = $item->donations->where('status', Status::DONATION_PAID);
                            $hasDonations = $donation->count();
                        @endphp
                        <tr>
                            <td>
                                <a href="{{ route('campaign.details', $item->slug) }}"target="_blank">
                                    {{ __(strLimit($item->title, 20)) }}
                                </a>
                            </td>
                            <td>{{ showAmount($item->goal, decimal:false) }}</td>
                            <td>{{ showAmount($donation->sum('donation'), decimal:false) }}</td>
                            <td>
                                @if ($item->goal_type == Status::GOAL_ACHIEVE)
                                    <span class="badge badge--primary">@lang('Achieve Goal')</span>
                                @elseif($item->goal_type == Status::CONTINUOUS)
                                    <span class="badge badge--success"> @lang('Continuous')</span>
                                @else
                                    <span class="badge badge--warning">
                                        {{ showDateTime($item->deadline, 'd-m-Y') }}</span>
                                @endif
                            </td>
                            <td>
                                @php echo $item->statusBadge; @endphp
                            </td>

                            <td>
                                <div class="btn-group dropdown">
                                    <button class="action-group-link action-icon-btn" data-bs-auto-close="outside"
                                        data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="fa-solid fa-list"></i>
                                    </button>
                                    <ul class="dropdown-menu dropdown--menu  px-2">
                                        @php
                                            $editAbleItem =
                                                $item->status == Status::PENDING ||
                                                ($item->goal_type == Status::AFTER_DEADLINE && $item->deadline < now());
                                        @endphp
                                        @if ($editAbleItem)
                                            <li>
                                                <a class="dropdown-item"
                                                    href="{{ route('user.campaign.fundrise.edit', $item->id) }}">
                                                    <i class="las la-edit"></i> @lang('Edit')
                                                </a>
                                            </li>
                                        @endif

                                        @if ($item->status == Status::CAMPAIGN_REJECTED)
                                            <li>
                                                <button class="dropdown-item confirmationBtn text--danger"
                                                    data-question="@lang('Are you sure to delete the expired campaign?')"
                                                    data-action="{{ route('user.campaign.fundrise.delete', $item->id) }}">
                                                    <i class="las la-trash"></i> @lang('Delete')
                                                </button>
                                            </li>
                                        @endif

                                        <li>
                                            <a class="dropdown-item" href="{{ route('campaign.details', $item->slug) }}"
                                                target="_blank">
                                                <i class="las la-desktop"></i> @lang('Explore Campaign')
                                            </a>
                                        </li>

                                        @if ($item->goal_type == Status::AFTER_DEADLINE && $item->deadline < now())
                                            <li>
                                                <button class="dropdown-item extendBtn text--base"
                                                    data-title="{{ $item->title }}" data-goal="{{ $item->goal }}"
                                                    data-action="{{ route('user.campaign.fundrise.extended', $item->id) }}">
                                                    <i class="las la-recycle"></i> @lang('Make Extend')
                                                </button>
                                            </li>
                                        @endif

                                        <li>
                                            <a class="dropdown-item"
                                                href="{{ route('user.campaign.donation.report', $item->id) }}">
                                                <i class="las la-user"></i> @lang('Donation Report')
                                            </a>
                                        </li>
                                        @if ($item->completed == Status::NO || $item->status != Status::CAMPAIGN_REJECTED)
                                            <li>
                                                <a target="_blank" class="dropdown-item"
                                                    href="{{ route('user.campaign.fundrise.seo', $item->id) }}">
                                                    <i class="las la-eye"></i> @lang('SEO Configuration')</a>
                                            </li>
                                        @endif
                                    </ul>
                                </div>

                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="mt-3">
                {{ paginateLinks($campaigns) }}
            </div>
        @else
            <div class="card custom--card  dashboard-sidebar overflow-y-auto">
                <div class="text-center py-3">
                    @include($activeTemplate . 'partials.empty', [
                        'message' => ucfirst(strtolower($pageTitle)) . ' not found!',
                    ])
                </div>
            </div>
        @endif
    </div>
    {{-- //Extend The Expired Campaign modal --}}
    <div class="modal custom--modal" id="extendedModal" role="dialog" tabindex="-1">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Are you sure to extend the campaign')?</h5>
                    <button class="btn-close" data-bs-dismiss="modal" type="button" aria-label="Close"></button>
                </div>
                <form method="POST">
                    <div class="modal-body">
                        <h4 class="campaign-title"></h4>
                        @csrf
                        <div class="form-group">
                            <label>@lang('Extend Deadline')</label>
                            <input class="datepicker-here form-control bg--white" name="deadline" data-language="en"
                                data-date-format="yyyy-mm-dd" type="text" value="{{ date('Y-m-d') }}" autocomplete="off"
                                required>
                            <small class="text-muted text--small"> <i class="la la-info-circle"></i>
                                @lang('Year-Month-Date')</small>
                        </div>
                        <div class="form-group">
                            <label>@lang('Extend Goal') </label>
                            <div class="input-group">
                                <input class="form-control" name="goal" type="number" value="{{ old('goal') }}"
                                    step="any" required>
                                <span class="input-group-text">{{ __(gs('cur_text')) }} </span>
                            </div>
                            <code class="was-goal"></code>
                        </div>
                        <div class="form-group">
                            <label>@lang('Final Goal')</label>
                            <div class="input-group">
                                <input class="form-control" name="final_goal" type="number"
                                    value="{{ old('final_goal') }}" step="any" required readonly>
                                <span class="input-group-text">{{ __(gs('cur_text')) }} </span>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--base btn-sm" type="submit">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <x-confirmation-modal :isFrontend="true" />
@endsection

@push('style-lib')
    <link href="{{ asset($activeTemplateTrue . 'css/datepicker.min.css') }}" rel="stylesheet">
@endpush

@push('script-lib')
    <script src="{{ asset($activeTemplateTrue . 'js/datepicker.min.js') }}"></script>
    <script src="{{ asset($activeTemplateTrue . 'js/datepicker.en.js') }}"></script>
@endpush

@push('script')
    <script>
        'use strict';

        (function($) {

            $('.extendBtn').on('click', function(e) {
                e.preventDefault();
                let route = $(this).data('action');
                let title = $(this).data('title');
                let goal = parseFloat($(this).data('goal'));
                let curText = `{{ __(gs('cur_text')) }}`;
                var modal = $('#extendedModal');
                modal.find('.modal-body .campaign-title').text(`${title}`);
                modal.find('.modal-body .was-goal').text(`@lang('Previous Goal'):` + `${goal}` + ' ' +
                    `${curText}`);
                modal.find('form').attr('action', route);

                $(document).on('input', '[name=goal]', function() {
                    const currentGoal = parseFloat($(this).val());
                    var finalGoal = goal + currentGoal;
                    $('[name=final_goal]').val(finalGoal);
                })

                modal.modal('show');
            });

            //date-validation
            $(document).on('click', 'form button[type=submit]', function(e) {
                if (new Date($('.datepicker-here').val()) == "Invalid Date") {
                    notify('error', 'Invalid extend deadline');
                    return false;
                }
            });
        })(jQuery);
    </script>
@endpush

@push('style')
    <style>
        .datepickers-container {
            z-index: 9999999999;
        }
    </style>
@endpush
