@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="d-xl-none position-relative z-1 mb-2">
        <button class="btn btn-outline--base" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight"
            aria-controls="offcanvasRight">
            <span class="icon"><i class="fa-solid fa-bars"></i></span>
            <span class="text">@lang('Menu')</span>
        </button>
    </div>
    <div class="card custom--card">
        <div class="card-body">
            <form class="action-form disableSubmission" action="{{ route('user.campaign.fundrise.store', $campaign->id) }}"
                method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form-label">@lang('Category')</label>
                            <div class="custom--select2 w-100">
                                <select class="form-control custom--select2 form-select select2" name="category_id"
                                    required>
                                    @foreach ($categories as $category)
                                        <option value="{{ $category->id }}" @selected($campaign->category_id == $category->id)>
                                            {{ __($category->name) }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form-label">@lang('Goal Amount')
                                <span data-bs-toggle="tooltip" data-bs-placement="top" type="button"
                                    title="{{ __('You will get :percentage of total raised', ['percentage' => 100 - @gs('raised_charge') . '%']) }}">
                                    <i class="las la-info-circle"></i>
                                </span>
                            </label>
                            <div class="input-group input--group">
                                <span class="input-group-text">{{ gs('cur_sym') }}</span>
                                <input class="form-control form--control" name="goal" type="number"
                                    value="{{ $campaign->goal }}" step="any" required>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label class="form-label">@lang('Title')</label>
                    <div class="input-group input--group">
                        <span class="input-group-text"><i class="las la-heading"></i></span>
                        <input class="form-control form--control" name="title" type="text"
                            value="{{ old('title', $campaign->title) }}" required>
                    </div>
                </div>
                <div class="form-group decide-deadline mb-3">
                    <label class="form-label">@lang('Decide how you want to complete your campaign?')</label>
                    <div class="form--radio">
                        <input class="form-check-input" id="after_goal" name="goal_type" type="radio" value="1"
                            @if ($campaign->goal_type == Status::GOAL_ACHIEVE) checked @endif>
                        <label class="form-check-label" for="after_goal">
                            @lang('After Goal Achieve')
                        </label>
                    </div>
                    <div class="form--radio">
                        <input class="form-check-input" id="after_deadline" name="goal_type" type="radio" value="2"
                            @if ($campaign->goal_type == Status::AFTER_DEADLINE) checked @endif>
                        <label class="form-check-label" for="after_deadline">
                            @lang('After Deadline')
                        </label>
                    </div>
                    <div class="form--radio">
                        <input class="form-check-input" id="continuous" name="goal_type" type="radio" value="3"
                            @if ($campaign->goal_type == Status::CONTINUOUS) checked @endif>
                        <label class="form-check-label" for="continuous">
                            @lang('Continuous')
                        </label>
                    </div>
                </div>
                <div class="form-group deadline-wrapper mb-3 @if ($campaign->goal_type != Status::AFTER_DEADLINE) d-none @endif">
                    <label class="form-label">@lang('Deadline')</label>
                    <div class="input-group input--group">
                        <span class="input-group-text"><i class="far fa-clock"></i></span>
                        <input class="datepicker-here form--control form-control" name="deadline" data-language="en"
                            data-position='bottom left' type="text"
                            value="{{ old('deadline', $campaign->goal_type == Status::AFTER_DEADLINE ? showDateTime($campaign->deadline, 'Y/m/d') : '') }}"
                            autocomplete="off">
                    </div>
                </div>
                <div class="form-group">
                    <label class="form-label">@lang('Description')<span class="text-danger">*</span></label>
                    <textarea class="form-control nicEdit" name="description" rows="8">{{ old('description', $campaign->description) }}</textarea>
                    <small>@lang('It can be long text and describe why the campaign was created').</small>
                </div>

                <div class="row">
                    <div class="col-12 mb-2">
                        <div class="alert alert-warning" role="alert">
                            <i class="las la-exclamation-circle"></i> @lang('Here you can change/replace campaign poster image and documents')
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="form-label">@lang('Poster Image') <span class="text--danger">*</span></label>
                            <div class="thumb-upload banner-thumb">
                                <label for="profilePicUpload2" class="thumb-upload__label">
                                    <input type="file" class="d-none profilePicUpload" id="profilePicUpload2"
                                        name="image" accept=".png, .jpg, .jpeg">
                                    <label class="icon" for="profilePicUpload2"><i
                                            class="fa-solid fa-camera cursor-pointer"></i></label>
                                    <span class="preview bg-img"
                                        data-background-image="{{ @getImage(getFilePath('campaign') . '/' . $campaign->image, '856x550') }}"></span>
                                </label>
                                <span class="thumb-upload__text mt-1"> @lang('Image will be resized into') ( <span
                                        class="text--danger">@lang('856px')</span> X <span
                                        class="text--danger">@lang('550px')</span> )
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="document-file mb-3">
                        <button type="button" class="flex-center btn btn-outline--base btn--sm add-new mb-2">
                            <i class="las la-plus-circle"></i>
                            <span>@lang('Add Documents')</span>
                        </button>
                        <div class="document-file__input">
                            <div class="form-group">
                                <input class="form-control form--control  mb-2" id="inputAttachments"
                                    name="attachments[]" type="file" accept=".jpg, .jpeg, .png, .pdf" />
                            </div>
                        </div>
                        <div id="fileUploadsContainer"></div>
                        <small class="text-muted"> @lang('Supported Files:')
                            <b>@lang('.png'), @lang('.jpg'), @lang('.pdf')</b>
                            @lang('Image will be resized into') <b>{{ getFileSize('proof') }}</b> @lang('px')</b>
                        </small>
                    </div>
                    <hr>
                    <div class="col-md-12 mb-4">
                        <div class="card border-0">
                            <div class="card-body p-0">
                                <h6 class="text-underline mb-2">@lang('Current Attachments'):</h6><br>
                                <ul class="nav custom--tab nav-tabs nav-tabs--style" id="myTab" role="tablist">
                                    <li class="nav-item " role="presentation">
                                        <a class="nav-link " id="gallery-tab" data-bs-toggle="tab" href="#gallery"
                                            role="tab" aria-controls="gallery"
                                            aria-selected="false">@lang('Proof Images')</a>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <a class="nav-link active" id="video-tab" data-bs-toggle="tab" href="#video"
                                            role="tab" aria-controls="video"
                                            aria-selected="false">@lang('Proof Document')</a>
                                    </li>
                                </ul>
                                @php
                                    $foundImg = false;
                                    $foundPdf = false;
                                    $proofImages = is_array($campaign->proof_images)
                                        ? $campaign->proof_images
                                        : (array) $campaign->proof_images;
                                    // Filter out non-PDF images
                                    $nonPdfImages = array_filter($proofImages, function ($image) {
                                        return explode('.', $image)[1] != 'pdf';
                                    });
                                    $totalImages = count($nonPdfImages);
                                @endphp
                                <div class="tab-content mt-4" id="myTabContent">
                                    <div class="tab-pane fade" id="gallery" role="tabpanel"
                                        aria-labelledby="gallery-tab">
                                        <div class="row gy-4">
                                            @foreach ($campaign->proof_images as $key => $image)
                                                @if (explode('.', $image)[1] != 'pdf')
                                                    @php
                                                        $foundImg = true;
                                                    @endphp
                                                    <div class="col-lg-4 col-sm-6 mb-30">
                                                        <div class="gallery-card">
                                                            <div class="gallery-card__thumb text-center">
                                                                <img class="rounded-3"
                                                                    src="{{ getImage(getFilePath('proof') . '/' . $image) }}"
                                                                    alt="image">
                                                                <button class="gallery-edit-btn confirmationBtn mt-2"
                                                                    type="button" data-question="@lang('Are you sure to remove this document?')"
                                                                    data-action="{{ route('user.campaign.fundrise.document.remove', ['id' => $campaign->id, 'key' => $key]) }}"
                                                                    {{ $totalImages === 1 ? 'disabled' : '' }}>
                                                                    <i class="las la-trash"></i> @lang('Delete')
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endif
                                            @endforeach

                                            @if (!$foundImg)
                                                @include($activeTemplate . 'partials.empty', [
                                                    'message' => 'Gallery image not found!',
                                                ])
                                            @endif
                                        </div>
                                    </div>
                                    <div class="tab-pane fade  show active" id="video" role="tabpanel"
                                        aria-labelledby="video-tab">
                                        <div class="row">
                                            @foreach ($campaign->proof_images as $key => $proof)
                                                @if (explode('.', $proof)[1] == 'pdf')
                                                    @php
                                                        $foundPdf = true;
                                                        $proofImages = is_array($campaign->proof_images)
                                                            ? $campaign->proof_images
                                                            : (array) $campaign->proof_images;
                                                        // Filter only PDF files
                                                        $pdfFiles = array_filter($proofImages, function ($proof) {
                                                            return explode('.', $proof)[1] == 'pdf';
                                                        });
                                                        $totalPdfFiles = count($pdfFiles);
                                                    @endphp

                                                    <div class="col-lg-6 text-center">
                                                        <div class="pdf-view">
                                                            <iframe class="iframe"
                                                                src="{{ getImage(getFilePath('proof') . '/' . $proof) }}"
                                                                frameborder="0"
                                                                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture, pdf"
                                                                allowfullscreen></iframe>
                                                            <button
                                                                class="btn btn-outline--danger btn--sm w-50 confirmationBtn"
                                                                type="button" data-question="@lang('Are you sure to remove this document?')"
                                                                data-action="{{ route('user.campaign.fundrise.document.remove', ['id' => $campaign->id, 'key' => $key]) }}"
                                                                {{ $totalPdfFiles === 1 ? 'disabled' : '' }}>
                                                                <i class="las la-trash"></i> @lang('Delete')
                                                            </button>
                                                        </div>
                                                    </div>
                                                @endif
                                            @endforeach
                                        </div>
                                        @if (!$foundPdf)
                                            @include($activeTemplate . 'partials.empty', [
                                                'message' => 'Document not found!',
                                            ])
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="faq-wrapper">
                            <div class="flex-between gap-2 add-faq-header">
                                <h6 class="text-underline mb-2">@lang('Campaign FAQs'):</h6>
                                <div class="add-new-faq addNewFAQ">
                                    <button type="button"
                                        class="flex-center btn btn-outline--base btn--sm w-100 add-new-faq-box">
                                        <i class="las la-plus-circle"></i>
                                        <span>@lang('Add New FAQ')</span>
                                    </button>
                                </div>
                            </div>
                            <div class="row gx-5 gy-4">
                                @foreach ($campaign->faqs->question ?? [] as $key => $faq)
                                    <div class="col-md-6 mb-3 ">
                                        <div class="form-group">
                                            <label class="form-label">@lang('Question')</label>
                                            <input class="form-control" name="question[]" type="text"
                                                value="{{ $campaign->faqs->question[$key] }}" required>
                                        </div>
                                        <div class="form-group">
                                            <label class="form-label">@lang('Answer')</label>
                                            <textarea class="form-control" name="answer[]" required>{{ $campaign->faqs->answer[$key] }}</textarea>
                                        </div>
                                        <button class="btn btn-outline--danger remove-btn w-100" type="button"
                                            disabled><i class="las la-trash"></i> @lang('Remove')</button>
                                    </div>
                                @endforeach
                                <div class="col-12 addFaqArea">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label class="privet-message form--check" for="donor_visibility">
                        <span class="custom--check">
                            <input class="form-check-input" id="donor_visibility" name="donor_visibility"
                                type="checkbox" @if ($campaign->donor_visibility == Status::YES) checked @endif>
                        </span>
                        <p class="form-check-label"><i class="las la-info-circle" data-bs-toggle="tooltip"
                                data-bs-placement="top" title="@lang('By default donor list showed on campaign explore page.')"></i> <small>@lang(' If You prefer to hide your donor list publicly, Please uncheck this box.')</small>
                        </p>
                    </label>
                </div>
                <button class="btn btn--base w-100" type="submit" type="submit">@lang('Update')</button>
            </form>
        </div>
    </div>
    <x-confirmation-modal :isFrontend="true" />
@endsection

@push('style-lib')
    <link href="{{ asset($activeTemplateTrue . 'css/datepicker.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('assets/global/css/select2.min.css') }}">
@endpush
@push('script-lib')
    <script src="{{ asset('assets/global/js/nicEdit.js') }}"></script>
    <script src="{{ asset($activeTemplateTrue . 'js/datepicker.min.js') }}"></script>
    <script src="{{ asset($activeTemplateTrue . 'js/datepicker.en.js') }}"></script>
    <script src="{{ asset('assets/global/js/select2.min.js') }}"></script>
@endpush

@push('style')
    <style>
        .decide-deadline {
            margin: 0;
        }

        .select2-container--default .select2-selection--single {
            border: 0 !important;
        }
    </style>
@endpush

@push('script')
    <script>
        'use strict';
        $(".add-new").on('click', function() {

            if ($("#fileUploadsContainer .input-group").length >= 4) {
                return;
            }
            $("#fileUploadsContainer").append(` <div class="input-group mb-2">
                <input type="file" name="attachments[]" id="inputAttachments" class="form-control form--control  mb-2" accept=".jpg, .jpeg, .png, .pdf" required/>
                        <button type="button" class="input-group-text btn--danger remove-btn"><i class="las la-times"></i></button>
                    </div>
                `);
        })

        $(document).on('click', '.remove-btn', function() {
            $(this).closest('.input-group').remove();
        });
        $(".nicEdit").each(function(index) {
            $(this).attr("id", "nicEditor" + index);
            new nicEditor({
                fullPanel: true
            }).panelInstance('nicEditor' + index, {
                hasPanel: true
            });
        });
        (function($) {
            $(document).on('mouseover ', '.nicEdit-main,.nicEdit-panelContain', function() {
                $('.nicEdit-main').focus();
            });
        })(jQuery);

        if (`{{ @$campaign->goal_type == 2 }}`) {
            $(document).on('click', 'form button[type=submit]', function(e) {
                if (new Date($('.datepicker-here').val()) == "Invalid Date") {
                    notify('error', 'Invalid deadline');
                    return false;
                }
            });
        }

        disableRemoveFaq();

        $('.addNewFAQ').on('click', function() {
            $(".addFaqArea").before(`
                <div class="col-lg-6">
                    <div class="form-group">
                        <label class="form-label">@lang('Question')</label>
                        <input type="text" name="question[]" class="form-control">
                    </div>
                    <div class="form-group">
                        <label class="form-label">@lang('Answer')</label>
                        <textarea name="answer[]" class="form-control"></textarea>
                    </div>
                    <button type="button" class="btn btn--danger remove-btn w-100"><i class="las la-trash"></i> @lang('Remove')</button>
            </div>
                `)
            disableRemoveFaq()
        });

        $(document).on('click', '.remove-btn', function() {
            $(this).closest('div').remove();
            disableRemoveFaq()
        });

        function disableRemoveFaq() {
            if ($(document).find('.remove-btn').length == 1) {
                $(document).find('.remove-btn').attr('disabled', true);
            } else {
                $(document).find('.remove-btn').removeAttr('disabled');
            }
        }

        $("[name='goal_type']").on('click', function() {
            if ($(this).val() == 2) {
                $('.deadline-wrapper').removeClass('d-none');
            } else {
                $('.deadline-wrapper').addClass('d-none');
            }
        })

        document.addEventListener("DOMContentLoaded", function() {
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
            var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl)
            })
        });
    </script>
@endpush

@push('style')
    <style>
        .iframe {
            width: 100%;
            height: 500px;
        }

        .add-new {
            margin-top: 31px !important;
        }
    </style>
@endpush
