@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="d-xl-none position-relative z-1 mb-3">
        <button class="btn btn-outline--base" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight"
            aria-controls="offcanvasRight">
            <span class="icon"><i class="fa-solid fa-bars"></i></span>
            <span class="text">@lang('Menu')</span>
        </button>
    </div>
    <div class="card custom--card">
        <div class="card-body">
            <form class="disableSubmission" method="POST"
                action="{{ route('user.campaign.fundrise.update.seo', $data->id) }}" enctype="multipart/form-data">
                @csrf
                <div class="row">
                    <div class="col-12">
                        <div class="form-group">
                            <label>@lang('SEO Image')</label>
                            <div class="thumb-upload banner-thumb">
                                <label for="profilePicUpload2" class="thumb-upload__label">
                                    <input type="file" class="d-none profilePicUpload" id="profilePicUpload2"
                                        name="image" accept=".png, .jpg, .jpeg">
                                    <label class="icon" for="profilePicUpload2"><i
                                            class="fa-solid fa-camera cursor-pointer"></i></label>
                                    <span class="preview bg-img"
                                        data-background-image="{{ frontendImage('campaign', @$data->seo_content->image, getFileSize('seo'), true) }}"></span>
                                </label>
                                <span class="thumb-upload__text mt-1"> @lang('Image will be resized into') ( <span
                                        class="text--danger">{{ getFileSize('seo') }}</span> )
                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="form-group select2-parent position-relative">
                            <label>@lang('Meta Keywords')</label>
                            <small class="ms-2 mt-2  ">@lang('Separate multiple keywords by') <code>,</code>(@lang('comma')) @lang('or')
                                <code>@lang('enter')</code> @lang('key')</small>
                            <select class="form-control form--control select2-auto-tokenize" name="keywords[]"
                                multiple="multiple">
                                @if (@$data->seo_content->keywords)
                                    @foreach (@$data->seo_content->keywords as $option)
                                        <option value="{{ $option }}" selected>{{ __($option) }}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>

                        <div class="form-group">
                            <label>@lang('Meta Description')</label>
                            <textarea class="form-control form--control" name="description" rows="3">{{ @$data->seo_content->description }}</textarea>
                        </div>
                        <div class="form-group">
                            <label>@lang('Social Title')</label>
                            <input class="form-control form--control" name="social_title" type="text"
                                value="{{ @$data->seo_content->social_title }}" />
                        </div>
                        <div class="form-group">
                            <label>@lang('Social Description')</label>
                            <textarea class="form-control form--control" name="social_description" rows="3">{{ @$data->seo_content->social_description }}</textarea>
                        </div>
                        <div class="form-group">
                            <button class="btn btn--base w-100" type="submit">@lang('Submit')</button>
                        </div>
                    </div>
                </div>
            </form>

        </div>
    </div>
@endsection

@push('style-lib')
    <link href="{{ asset('assets/global/css/select2.min.css') }}" rel="stylesheet">
@endpush

@push('script-lib')
    <script src="{{ asset('assets/global/js/select2.min.js') }}"></script>
@endpush
@push('script')
    <script>
        (function($) {
            "use strict";
            $('.select2-auto-tokenize').select2({
                dropdownParent: $('.select2-parent'),
                tags: true,
                tokenSeparators: [',']
            });

            function proPicURL(input) {
                if (input.files && input.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        var preview = $(input).parents('.profile-thumb').find('.profilePicPreview');
                        $(preview).css('background-image', 'url(' + e.target.result + ')');
                        $(preview).addClass('has-image');
                        $(preview).hide();
                        $(preview).fadeIn(650);
                    }
                    reader.readAsDataURL(input.files[0]);
                }
            }
            $(".profilePicUpload").on('change', function() {
                proPicURL(this);
            });

            $(".remove-image").on('click', function() {
                $(".profilePicPreview").css('background-image', 'none');
                $(".profilePicPreview").removeClass('has-image');
            })
        })(jQuery);
    </script>
@endpush
