@extends($activeTemplate . 'layouts.master')

@section('content')
    <div class="user-details__content">
        @if (!blank($campaigns))
        <div class="ms-auto mb-3">
            <form class="header-search-from">
                <div class="input-group style-two">
                    <input type="search" class="form-control form--control bg-white" name="search" value="{{ request()->search }}"
                        placeholder="@lang('Search by title')">
                    <button class="input-group-text bg--base text-white">
                        <i class="fa-solid fa-magnifying-glass"></i>
                    </button>
                </div>
            </form>
        </div>
            <table class="table custom--table table--responsive--md">
                <thead>
                    <tr>
                        <th>@lang('S.N.')</th>
                        <th>@lang('TITLE')</th>
                        <th>@lang('GOAL') | @lang('RAISED')</th>
                        <th>@lang('DEADLINE') | @lang('CREATED AT')</th>
                        <th>@lang('ACTION')</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($campaigns as $item)
                        @php
                            $donation = $item->donations->where('status', Status::DONATION_PAID);
                            $hasDonations = $donation->count();
                        @endphp
                        <tr>
                            <td>{{ $loop->index + $campaigns->firstItem() }}</td>
                            <td>
                                <div>
                                    <a class="dropdown-item" href="{{ route('campaign.details', $item->slug) }}"
                                        target="__blank">
                                        {{ __(strLimit($item->title, 20)) }}
                                    </a>
                                </div>
                            </td>
                            <td>{{ showAmount($item->goal) }} <br>
                                <div>
                                    <small>
                                        {{ showAmount($item->donations->where('status', Status::DONATION_PAID)->sum('donation')) }}
                                    </small>
                                </div>
                            </td>
                            <td>
                                <div>
                                    @if ($item->goal_type == Status::GOAL_ACHIEVE)
                                        <span class="badge badge--primary">@lang('Achieve Goal')</span>
                                    @elseif($item->goal_type == Status::CONTINUOUS)
                                        <span class="badge badge--success"> @lang('Continuous')</span>
                                    @else
                                        <span class="badge badge--warning">
                                            {{ showDateTime($item->deadline, 'd-m-Y') }}</span>
                                    @endif
                                    <span class="d-block">{{ diffForHumans($item->created_at) }}</span>
                                </div>
                            </td>
                            <td>
                                <div class="btn-group">
                                    <button class="action-group-link action-icon-btn"
                                        data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="fa-solid fa-list"></i>
                                    </button>
                                    <ul class="dropdown-menu dropdown--menu px-2">
                                        @if (request()->routeIs('user.campaign.fundrise.pending'))
                                            @if ($item->expired())
                                                <li>
                                                    <a class="dropdown-item"
                                                        href="{{ route('user.campaign.fundrise.edit', $item->id) }}">
                                                        <i class="las la-edit"></i> @lang('Edit')
                                                    </a>
                                                </li>
                                            @endif
                                        @endif

                                        @if (request()->routeIs('user.campaign.fundrise.rejected'))
                                            <li>
                                                <button class="dropdown-item confirmationBtn text--danger"
                                                    data-question="@lang('Are you sure to delete the expired campaign?')"
                                                    data-action="{{ route('user.campaign.fundrise.delete', $item->id) }}">
                                                    <i class="las la-trash"></i> @lang('Delete')
                                                </button>
                                            </li>
                                        @endif

                                        @if (request()->routeIs('user.campaign.fundrise.pending') ||
                                                request()->routeIs('user.campaign.fundrise.rejected') ||
                                                request()->routeIs('user.campaign.fundrise.complete'))
                                            <li>
                                                <a class="dropdown-item"
                                                    href="{{ route('campaign.details', $item->slug) }}" target="__blank">
                                                    <i class="las la-desktop"></i> @lang('Explore Campaign')
                                                </a>
                                            </li>
                                        @else
                                            <li>
                                                <a class="dropdown-item"
                                                    href="{{ route('campaign.details', $item->slug) }}" target="__blank">
                                                    <i class="las la-desktop"></i> @lang('Explore Campaign')
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item "
                                                    href="{{ route('user.campaign.donation.report', $item->id) }}">
                                                    <i class="las la-user"></i>@lang('Donation Report')
                                                </a>
                                            </li>

                                            @if ($item->completed == Status::NO)
                                                <li>
                                                    <button class="dropdown-item confirmationBtn text--base"
                                                        data-question="@lang('Are you sure to mark as complete? Because this action can\'t back again! And can\'t relaunch again')"
                                                        data-action="{{ route('user.campaign.fundrise.make.complete', $item->id) }}">
                                                        <i class="las la-check"></i> @lang('Mark as Complete')
                                                    </button>
                                                </li>
                                            @endif

                                            @if (!request()->routeIs('user.campaign.fundrise.expired'))
                                                @if ($item->stop)
                                                    <li>
                                                        <button class="dropdown-item confirmationBtn text--base"
                                                            data-question="@lang('Are you sure to start this campaign?')"
                                                            data-action="{{ route('user.campaign.fundrise.stop', $item->id) }}">
                                                            <i class="las la-pause-circle"></i>
                                                            @lang('Resume Campaign')
                                                        </button>
                                                    @else
                                                        <button class="dropdown-item confirmationBtn text--base"
                                                            data-question="@lang('Are you sure to pause/stop this campaign?')"
                                                            data-action="{{ route('user.campaign.fundrise.stop', $item->id) }}">
                                                            <i class="las la-pause-circle"></i>
                                                            @lang('Pause Campaign')
                                                        </button>
                                                    </li>
                                                @endif
                                            @endif
                                        @endif
                                        @if ($item->completed == Status::NO || $item->status != Status::CAMPAIGN_REJECTED)
                                            <li>
                                                <a class="dropdown-item"
                                                    href="{{ route('user.campaign.fundrise.seo', $item->id) }}"
                                                    target="_blank"> <i class="las la-eye"></i>
                                                    @lang('SEO Configuration')</a>
                                            </li>
                                        @endif
                                        <li>
                                            <a class="dropdown-item"
                                                href="{{ route('user.campaign.fundrise.update', $item->id) }}">
                                                <i class="las la-sync"></i> @lang('Update Log')
                                            </a>
                                        </li>

                                    </ul>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="mt-3">
                {{ paginateLinks($campaigns) }}
            </div>
        @else
        <div class="card custom--card  dashboard-sidebar overflow-y-auto">
            <div class="text-center py-3">
                @include($activeTemplate . 'partials.empty', [
                    'message' => ucfirst(strtolower($pageTitle)) . ' not found!',
                ])
            </div>
        </div>
        @endif
    </div>
    <x-confirmation-modal :isFrontend="true" />
@endsection
