@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="row gy-4">
        <div class="col-12 d-xl-none">
            <div class="position-relative z-1">
                <button class="btn btn-outline--base" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight"
                    aria-controls="offcanvasRight">
                    <span class="icon"><i class="fa-solid fa-bars"></i></span>
                    <span class="text">@lang('Menu')</span>
                </button>
            </div>
        </div>
        @if (!$user->ts)
            <div class="col-lg-12">
                <div class="alert border border-warning d-flex gap-3 flex-sm-nowrap flex-wrap" role="alert">
                    <span class="alert__icon d-flex align-items-center text-warning "><i class="las la-user-lock"></i>
                    </span>
                    <p class="alert__message">
                        <span class="fw-bold">@lang('2FA Authentication')</span><br>
                        <small>
                            <i>
                                @lang('To keep safe your account, Please enable') <a class="link-color text--base"
                                    href="{{ route('user.twofactor') }}">@lang('2FA')
                                </a>
                                @lang('security').</i>
                            @lang('It will make secure your account and balance.')
                        </small>
                    </p>
                </div>
            </div>
        @endif

        @php
            $kyc = getContent('kyc.content', true);
        @endphp

        @if (auth()->user()->kv == Status::KYC_UNVERIFIED && auth()->user()->kyc_rejection_reason)
            <div class="col-12">
                <div class="alert border border-danger flex-align flex-nowrap gap-4" role="alert">
                    <div class="alert__message">
                        <div class="flex-between mb-2">
                            <span class="fw-bold d-block">@lang('KYC Documents Rejected')</span>
                            <button data-bs-toggle="modal" class="btn btn--sm btn--base"
                                data-bs-target="#kycRejectionReason">@lang('Show Reason')</button>
                        </div>

                        {{ __(@$kyc->data_values->reject) }}
                        <a class="text--base" href="{{ route('user.kyc.form') }}">@lang('Click Here to Re-submit Documents')</a>,
                        <a class="text--base" href="{{ route('user.kyc.data') }}">@lang('See KYC Data')</a>
                    </div>
                </div>
            </div>
        @elseif(auth()->user()->kv == Status::KYC_UNVERIFIED)
            <div class="col-12">
                <div class="alert border border-info flex-align flex-nowrap gap-4" role="alert">
                    <div class="alert__message">
                        <span class="fw-bold">@lang('KYC Verification required')</span>
                        <p class="mb-0">{{ __(@$kyc->data_values->required) }} <a class="text--base"
                                href="{{ route('user.kyc.form') }}">@lang('Click Here to Submit Documents')</a></p>
                    </div>
                </div>
            </div>
        @elseif(auth()->user()->kv == Status::KYC_PENDING)
            <div class="col-12">
                <div class="alert border border-warning flex-align flex-nowrap gap-4" role="alert">
                    <div class="alert__message">
                        <span class="fw-bold">@lang('KYC Verification pending')</span>
                        <p class="mb-0">{{ __(@$kyc->data_values->pending) }} <a class="text--base"
                                href="{{ route('user.kyc.data') }}">@lang('See KYC Data')</a></p>
                    </div>
                </div>
            </div>
        @endif

        <div class="col-12">
            <div class="dashboard-widget-wrapper">
                <div class="row gy-4">
                    <div class="col-xxl-3 col-xl-4 col-lg-3 col-md-4 col-sm-6 col-xsm-6">
                        <!--========================== Dashboard-widget Start ==========================-->
                        <a href="{{ route('user.campaign.fundrise.all') }}" class="dashboard-widget">
                            <div class="dashboard-widget__content">
                                <h4 class="dashboard-widget__title">{{ $campaign['total_campaign'] }}</h4>
                                <span class="dashboard-widget__icon"><i class="fa-solid fa-chart-simple"></i></span>
                            </div>
                            <div class="dashboard-widget__footer">
                                <p class="dashboard-widget__text">@lang('Total Campaigns')</p>
                            </div>
                        </a>
                        <!--========================== Dashboard-widget End ==========================-->
                    </div>
                    <div class="col-xxl-3 col-xl-4 col-lg-3 col-md-4 col-sm-6 col-xsm-6">
                        <!--========================== Dashboard-widget Start ==========================-->
                        <a href="{{ route('user.campaign.fundrise.pending') }}" class="dashboard-widget">
                            <div class="dashboard-widget__content">
                                <h4 class="dashboard-widget__title">{{ $campaign['pending'] }}</h4>
                                <span class="dashboard-widget__icon"><i class="fa-solid fa-spinner"></i></span>
                            </div>
                            <div class="dashboard-widget__footer">
                                <p class="dashboard-widget__text">@lang('Pending Campaigns')</p>
                            </div>
                        </a>
                        <!--========================== Dashboard-widget End ==========================-->
                    </div>
                    <div class="col-xxl-3 col-xl-4 col-lg-3 col-md-4 col-sm-6 col-xsm-6">
                        <!--========================== Dashboard-widget Start ==========================-->
                        <a href="{{ route('user.campaign.fundrise.complete') }}" class="dashboard-widget">
                            <div class="dashboard-widget__content">
                                <h4 class="dashboard-widget__title">{{ $campaign['completed'] }}</h4>
                                <span class="dashboard-widget__icon"><i class="fa-solid fa-list"></i></span>
                            </div>
                            <div class="dashboard-widget__footer">
                                <p class="dashboard-widget__text">@lang('Completed Campaigns')</p>
                            </div>
                        </a>
                        <!--========================== Dashboard-widget End ==========================-->
                    </div>
                    <div class="col-xxl-3 col-xl-4 col-lg-3 col-md-4 col-sm-6 col-xsm-6">
                        <!--========================== Dashboard-widget Start ==========================-->
                        <a href="{{ route('user.campaign.fundrise.rejected') }}" class="dashboard-widget">
                            <div class="dashboard-widget__content">
                                <h4 class="dashboard-widget__title">{{ $campaign['rejectLog'] }}</h4>
                                <span class="dashboard-widget__icon"><i class="fa-regular fa-circle-xmark"></i></span>

                            </div>
                            <div class="dashboard-widget__footer">
                                <p class="dashboard-widget__text">@lang('Rejected Campaigns')</p>
                            </div>
                        </a>
                        <!--========================== Dashboard-widget End ==========================-->
                    </div>
                    <div class="col-xxl-3 col-xl-4 col-lg-3 col-md-4 col-sm-6 col-xsm-6">
                        <!--========================== Dashboard-widget Start ==========================-->
                        <a href="{{ route('user.campaign.donation.received') }}" class="dashboard-widget">
                            <div class="dashboard-widget__content">
                                <h4 class="dashboard-widget__title">
                                    {{ gs('cur_sym') . showAmount($campaign['received_donation'], 0, true, false, false) }}
                                </h4>
                                <span class="dashboard-widget__icon"><i class="fa-solid fa-check-double"></i></span>
                            </div>
                            <div class="dashboard-widget__footer">
                                <p class="dashboard-widget__text">@lang('Total Received Donation')</p>
                            </div>
                        </a>
                        <!--========================== Dashboard-widget End ==========================-->
                    </div>
                    <div class="col-xxl-3 col-xl-4 col-lg-3 col-md-4 col-sm-6 col-xsm-6">
                        <!--========================== Dashboard-widget Start ==========================-->
                        <a href="{{ route('user.campaign.donation.given') }}" class="dashboard-widget">
                            <div class="dashboard-widget__content">
                                <h4 class="dashboard-widget__title">
                                    {{ gs('cur_sym') . showAmount($campaign['give_donation'], 0, true, false, false) }}
                                </h4>
                                <span class="dashboard-widget__icon"><i class="fa-solid fa-hand-holding-hand"></i></span>
                            </div>
                            <div class="dashboard-widget__footer">
                                <p class="dashboard-widget__text">@lang('Total Given Donation')</p>
                            </div>
                        </a>
                        <!--========================== Dashboard-widget End ==========================-->
                    </div>
                    <div class="col-xxl-3 col-xl-4 col-lg-3 col-md-4 col-sm-6 col-xsm-6">
                        <!--========================== Dashboard-widget Start ==========================-->
                        <a href="{{ route('user.withdraw.history') }}" class="dashboard-widget">
                            <div class="dashboard-widget__content">
                                <h4 class="dashboard-widget__title">
                                    {{ gs('cur_sym') . showAmount($campaign['withdraw'], 0, true, false, false) }}</h4>
                                <span class="dashboard-widget__icon"><i
                                        class="fa-solid fa-money-bill-transfer"></i></span>
                            </div>
                            <div class="dashboard-widget__footer">
                                <p class="dashboard-widget__text">@lang('Total Withdraw')</p>
                            </div>
                        </a>
                        <!--========================== Dashboard-widget End ==========================-->
                    </div>
                    <div class="col-xxl-3 col-xl-4 col-lg-3 col-md-4 col-sm-6 col-xsm-6">
                        <!--========================== Dashboard-widget Start ==========================-->
                        <div class="dashboard-widget mb--60">
                            <div class="dashboard-widget__content">
                                <h4 class="dashboard-widget__title">
                                    {{ gs('cur_sym') . showAmount($campaign['current_balance'], 0, true, false, false) }}
                                </h4>
                                <span class="dashboard-widget__icon"><i class="fa-solid fa-comment-dollar"></i></span>
                            </div>
                            <div class="dashboard-widget__footer">
                                <p class="dashboard-widget__text">@lang('Current Balance')</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card custom--card">
                <div class="card-body">
                    <div id="donation-chart"></div>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card custom--card">
                <div class="card-body">
                    <div id="withdrawal-chart"></div>
                </div>
            </div>
        </div>
    </div>

    @if (auth()->user()->kv == Status::KYC_UNVERIFIED && auth()->user()->kyc_rejection_reason)
        <div class="modal fade custom--modal" id="kycRejectionReason">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">@lang('KYC Document Rejection Reason')</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p>{{ auth()->user()->kyc_rejection_reason }}</p>
                    </div>
                </div>
            </div>
        </div>
    @endif
@endsection

@push('script')
    <script src="{{ asset($activeTemplateTrue . 'js/apexchart.js') }}" charset="utf-8"></script>
    <script>
        'use strict';

        document.addEventListener('DOMContentLoaded', function() {
            // Data for donations graph
            const donationDays = @json($donations['perDay']);
            const donationAmounts = @json($donations['perDayAmount']);

            const donationChartOptions = {
                chart: {
                    type: 'bar',
                    height: 350,
                    toolbar: {
                        show: false
                    },
                },
                series: [{
                    name: "@lang('Donations')",
                    data: donationAmounts,
                }],
                xaxis: {
                    categories: donationDays,
                    title: {
                        text: "@lang('Date')"
                    },
                },
                yaxis: {
                    title: {
                        text: "@lang('Amount')"
                    },
                },
                title: {
                    text: "@lang('Last 30 Days Paid Donation Report')",
                    align: 'center',
                },
            };

            const donationChart = new ApexCharts(document.querySelector("#donation-chart"), donationChartOptions);
            donationChart.render();

            // Data for withdrawals graph
            const withdrawalDays = @json($withdrawals['perDay']);
            const withdrawalAmounts = @json($withdrawals['perDayAmount']);

            const withdrawalChartOptions = {
                chart: {
                    type: 'bar',
                    height: 350,
                    toolbar: {
                        show: false
                    },
                },
                series: [{
                    name: "@lang('Withdrawals')",
                    data: withdrawalAmounts,
                }],
                xaxis: {
                    categories: withdrawalDays,
                    title: {
                        text: "@lang('Date')"
                    },
                },
                yaxis: {
                    title: {
                        text: "@lang('Amount')"
                    },
                },
                title: {
                    text: "@lang('Last 30 Days Withdrawal Report')",
                    align: 'center',
                },
            };

            const withdrawalChart = new ApexCharts(document.querySelector("#withdrawal-chart"),
                withdrawalChartOptions);
            withdrawalChart.render();
        });
    </script>
@endpush
