@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="d-xl-none position-relative z-1 mb-3">
        <button class="btn btn-outline--base" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight"
            aria-controls="offcanvasRight">
            <span class="icon"><i class="fa-solid fa-bars"></i></span>
            <span class="text">@lang('Menu')</span>
        </button>
    </div>
    <div>
        @if (!blank($donations))
            <div class="col-12">
                <table class="table custom--table table--responsive--md">
                    <thead>
                        <tr>
                            <th>@lang('S.N.')</th>
                            <th>@lang('Trx')</th>
                            <th>@lang('Name')</th>
                            <th>@lang('Email')</th>
                            <th>@lang('Mobile')</th>
                            <th>@lang('Country')</th>
                            <th>@lang('Amount')</th>
                            <th>@lang('Action')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($donations as $donation)
                            <tr>
                                <td>{{ $donations->firstItem() + $loop->index }}</td>
                                <td>{{ @$donation->deposit->trx }}</td>
                                <td>{{ __($donation->fullname) }}</td>
                                <td>{{ $donation->email }}</td>
                                <td>{{ $donation->mobile }}</td>
                                <td>{{ $donation->country }}</td>
                                <td>{{ showAmount($donation->donation) }}</td>
                                <td>
                                    <a href="{{ route('user.campaign.donation.details', [$donation->id, 'slug' => $given]) }}" class="action-icon-btn show-details"><i class="la la-desktop"></i></a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            @if ($donations->hasPages())
                @php echo paginateLinks($donations) @endphp
            @endif
        @else
        <div class="card custom--card  dashboard-sidebar overflow-y-auto">
            @include($activeTemplate . 'partials.empty', ['message' => 'Donations not found!'])
        </div>
        @endif
    </div>
@endsection
