@extends($activeTemplate . 'layouts.master')

@section('content')
    <div class="d-xl-none position-relative z-1 mb-3">
        <button class="btn btn-outline--base" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight"
            aria-controls="offcanvasRight">
            <span class="icon"><i class="fa-solid fa-bars"></i></span>
            <span class="text">@lang('Menu')</span>
        </button>
    </div>

    <div class="container">
        <div class="row gy-4">
            <div class="col-12">
                <div class="card custom--card">
                    <div class="card-header">
                        <div class="row g-2 align-items-center">
                            <div class="col-sm-6">
                                <h5 class="card-title mb-0 mr-3">@lang('Total Donation')</h5>
                                <span class="ml-5 text--base totalAmount"> </span>
                            </div>
                            <div class="col-sm-6">
                                <div class="">
                                    <select class="widget_select custom--select2 form-control form-select select2"
                                        name="donation_time">
                                        <option value="week">@lang('Current Week')</option>
                                        <option value="month" selected>@lang('Current Month')</option>
                                        <option value="year">@lang('Current Year')</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body text-center pb-0 px-0">
                        <div id="chart-area"></div>
                    </div>
                </div>
            </div>
            @if (!blank($donations))
                <div class="col-12">
                    <div class="card custom--card has-table">
                        <div class="card-body p-0">
                            <table class="table custom--table table--responsive--md">
                                <thead>
                                    <tr>
                                        <th>@lang('S.N.')</th>
                                        <th>@lang('TRX')</th>
                                        <th>@lang('NAME')</th>
                                        <th>@lang('EMAIL')</th>
                                        <th>@lang('MOBILE')</th>
                                        <th>@lang('COUNTRY')</th>
                                        <th>@lang('AMOUNT')</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($donations as $item)
                                        <tr>
                                            <td data-label="S.N.">{{ $donations->firstItem() + $loop->index }}</td>
                                            <td data-label="Trx">{{ @$item->deposit->trx ?? '---' }}</td>
                                            <td data-label="Name">{{ __($item->fullname) }}</td>
                                            <td data-label="Email">{{ $item->email }}</td>
                                            <td data-label="Mobile">{{ $item->mobile }}</td>
                                            <td data-label="Country">{{ $item->country }}</td>
                                            <td data-label="Amount">{{ showAmount($item->donation) }} </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    @if ($donations->hasPages())
                        @php echo paginateLinks($donations) @endphp
                    @endif
                </div>
            @else
                <div class="col-12">
                    <div class="card custom--card  dashboard-sidebar overflow-y-auto">
                        @include($activeTemplate . 'partials.empty', [
                            'message' => 'This campaign has no donation!',
                        ])
                    </div>
                </div>
            @endif
        </div>


    </div>
@endsection

@push('style')
    <style>
        .widget_select {
            padding: 3px 3px;
            font-size: 13px;
        }
    </style>
@endpush

@push('script')
    <script src="{{ asset('assets/admin/js/vendor/apexcharts.min.js') }}"></script>
    <script src="{{ asset('assets/admin/js/vendor/chart.js.2.8.0.js') }}"></script>
    <script>
        'use strict';

        (function($) {
            $('.select2').select2({
                minimumResultsForSearch: -1
            });

            var chart;

            $('[name=donation_time]').on('change', function() {
                let time = $(this).val();
                let campaign = `{{ @$campaignId }}`;
                let url = "{{ route('user.campaign.donation.donor.report') }}";

                $.get(url, {
                    time: time,
                    campaign_id: campaign
                }, function(response) {
                    if (!response.chart_data) {
                        console.error('No chart data available');
                        return;
                    }

                    let paidData = [];
                    let labels = [];


                    $.each(response.chart_data, function(label, value) {
                        labels.push(label);
                        paidData.push(value.paid);
                    });

                    $('.totalAmount').text(`{{ gs('cur_sym') }}` + response.total_amount);

                    var options = {
                        series: [{
                            name: "Donation",
                            data: paidData
                        }],
                        chart: {
                            type: 'area',
                            height: 350,
                            zoom: {
                                enabled: false
                            }
                        },
                        dataLabels: {
                            enabled: false
                        },
                        stroke: {
                            curve: 'straight'
                        },
                        labels: labels,
                        yaxis: {
                            opposite: true
                        },
                        xaxis: {
                            categories: labels,
                        },
                        legend: {
                            horizontalAlign: 'left'
                        }
                    };

                    if (chart) {
                        chart.destroy();
                    }

                    chart = new ApexCharts(document.querySelector("#chart-area"),
                        options); // Reuse the `chart` variable without re-declaring it
                    chart.render();

                }).fail(function(jqXHR, textStatus, errorThrown) {
                    console.error('Failed to fetch data:', textStatus, errorThrown);
                });
            }).change();
        })(jQuery);
    </script>
@endpush
