@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="user-details__content">
        <div class="flex-align gap-2">
            <div class="d-xl-none position-relative z-1">
                <button class="btn btn-outline--base" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight"
                    aria-controls="offcanvasRight">
                    <span class="icon"><i class="fa-solid fa-bars"></i></span>
                    <span class="text">@lang('Menu')</span>
                </button>
            </div>
            @if (!blank($favorites))
                <form class="header-search-from flex-fill">
                    <div class="input-group style-two mb-3">
                        <input type="search" class="form-control form--control bg-white" name="search" value="{{ request()->search }}"
                            placeholder="@lang('Search by title')">
                        <button class="input-group-text bg--base text-white">
                            <i class="fa-solid fa-magnifying-glass"></i>
                        </button>
                    </div>
                </form>
            @endif 
        </div>
        @if (!blank($favorites))
            <table class="table custom--table table--responsive--md">
                <thead>
                    <tr>
                        <th>@lang('TITLE')</th>
                        <th>@lang('OWNER')</th>
                        <th>@lang('GOAL')</th>
                        <th>@lang('FUND RAISED')</th>
                        <th>@lang('DEADLINE')</th>
                        <th>@lang('ACTION')</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($favorites as $favorite)
                        @php
                            $donation = $favorite->campaign->donations->where('status', Status::DONATION_PAID);
                            $hasDonations = $donation->count();
                        @endphp
                        <tr>
                            <td>
                                <a href="{{ route('campaign.details', $favorite->campaign->slug) }}">
                                    {{ __(strLimit($favorite->campaign->title, 20)) }}
                                </a>
                            </td>
                            <td>
                                <div class="d-flex align-items-center gap-2">
                                    <div class="avatar">
                                        @if ($favorite->campaign->user->enable_org)
                                            <img src="{{ avatar(@$favorite->campaign->user->organization->image ? getFilePath('orgProfile') . '/' . @$favorite->campaign->user->organization->image : null) }}"
                                                alt="org-cover-avatar">
                                        @else
                                            <img src="{{ avatar(@$favorite->campaign->user->image ? getFilePath('userProfile') . '/' . @$favorite->campaign->user->image : null) }}"
                                                alt="user-avatar">
                                        @endif
                                    </div>
                                    <a href="{{ route('profile.index', $favorite->campaign->user->username) }}">
                                        <span class="text">
                                            @if ($favorite->campaign->user->enable_org)
                                                {{ __($favorite->campaign->user->Organization->name) }}
                                            @else
                                                {{ __($favorite->campaign->user->fullname) }}
                                            @endif
                                        </span>
                                    </a>
                                </div>
                            </td>
                            <td>{{ showAmount($favorite->campaign->goal, decimal:false) }}</td>
                            <td>{{ showAmount($donation->sum('donation')) }}</td>
                            <td>
                                @if ($favorite->campaign->goal_type == Status::GOAL_ACHIEVE)
                                    <span class="badge badge--primary">@lang('Achieve Goal')</span>
                                @elseif($favorite->campaign->goal_type == Status::CONTINUOUS)
                                    <span class="badge badge--success"> @lang('Continuous')</span>
                                @else
                                    <span class="badge badge--warning">
                                        {{ showDateTime($favorite->campaign->deadline, 'd-m-Y') }}</span>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('campaign.details', $favorite->campaign->slug) }}"
                                    class="action-icon-btn">
                                    <i class="fa-solid fa-eye"></i>
                                </a>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="mt-3">
                {{ paginateLinks($favorites) }}
            </div>
        @else
            <div class="card custom--card  dashboard-sidebar overflow-y-auto">
                @include($activeTemplate . 'partials.empty', ['message' => 'Favorite campaigns not found!'])
            </div>
        @endif
    </div>
@endsection
