@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="d-xl-none position-relative z-1 mb-2">
        <button class="btn btn-outline--base" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight"
            aria-controls="offcanvasRight">
            <span class="icon"><i class="fa-solid fa-bars"></i></span>
            <span class="text">@lang('Menu')</span>
        </button>
    </div>
    <div class="container">
        <div class="card custom--card ">
            @include($activeTemplate . 'partials.organizational_header')
            @if ($org)
            <div class="flex-between gap-2 p-3 py-md-4">
                <h5 class="my-2">
                    @lang('Organization'): {{ __(@$org->name) }}
                </h5>
                    <button class="btn btn-sm btn--base awardModalBtn" data-modal_title="@lang('Add New Award')">
                        <i class="las la-plus"></i>@lang('New')
                    </button>
                </div>
                @endif
            @if($org)
                @if (!blank($awards))
                    <div class="table custom--table table--responsive--md has-table-card mb-3">
                        <table class="table custom--table table--responsive--md has-table-card">
                            <thead>
                                <tr>
                                    <th>@lang('Image')</th>
                                    <th>@lang('Title')</th>
                                    <th>@lang('Contribution')</th>
                                    <th>@lang('Institute')</th>
                                    <th class="dp-action">@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($awards as $award)
                                    <tr>
                                        <td data-label="Image">
                                            <div class="avatar">
                                                <img class="avatar__img"
                                                    src="{{ getImage(getFilePath('orgAward') . '/' . @$award->image, getFileSize('orgAward')) }}">
                                            </div>
                                        </td>
                                        <td>
                                            {{ strLimit(__($award->title), 50) }}
                                        </td>
                                        <td>
                                            {{ strLimit(__($award->contribution), 60) }}
                                        </td>
                                        <td>
                                            {{ __($award->institute) }}
                                        </td>
                                        @php
                                            $award->image_with_path = getImage(
                                                getFilePath('orgAward') . '/' . $award->image,
                                                getFileSize('orgAward'),
                                            );
                                        @endphp
                                        <td>
                                            <div class="btn-group">
                                                <button data-bs-toggle="dropdown" aria-expanded="false"
                                                    class="action-group-link action-icon-btn">
                                                    <i class="fa-solid fa-list"></i>
                                                </button>
                                                <ul class="dropdown-menu dropdown--menu px-2">
                                                    <li>
                                                        <button class="dropdown-item awardModalBtn text--base"
                                                            data-modal_title="@lang('Update Award')"
                                                            data-resource="{{ $award }}">
                                                            <i class="las la-pen"></i> @lang('Edit')
                                                        </button>
                                                    </li>
                                                    <li>
                                                        <button class="dropdown-item confirmationBtn text--danger"
                                                            data-question="@lang('Are you sure to remove this award?')"
                                                            data-action="{{ route('user.org.award.delete', $award->id) }}">
                                                            <i class="las la-trash"></i> @lang('Delete')
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @if ($awards->hasPages())
                        <div class="pt-3">
                            {{ paginateLinks($awards) }}
                        </div>
                    @endif
                @else
                    <div class="mb-3">
                        @include($activeTemplate . 'partials.empty', [
                            'message' => 'No rewarded Yet!',
                        ])
                    </div>
                @endif
            @else
                <div class="card custom--card  dashboard-sidebar overflow-y-auto">
                    <div class="empty-files">
                        <h5 class="text-center">@lang('You have to create an organization first to add awards')</h5>
                    </div>
                </div>
            @endif
            @php
                $awardImage = getImage(getFilePath('orgAward'), getFileSize('orgAward'));
            @endphp
        </div>
    </div>


    @if ($org)
        <div class="modal custom--modal" id="awardModal">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <form action="{{ route('user.org.award') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        <div class="modal-header">
                            <h5 class="mb-0 modal-title"></h5>
                            <button class="btn-close" data-bs-dismiss="modal" type="button"></button>
                        </div>
                        <div class="modal-body p-4">

                            <div class="form-group mt-4">
                                <label class="form-label">@lang('Award Photo')</label>
                                <div class="thumb-upload banner-thumb">
                                    <label for="profilePicUpload2" class="thumb-upload__label">
                                        <input type="file" class="d-none profilePicUpload" id="profilePicUpload2"
                                            name="image" accept=".png, .jpg, .jpeg">
                                        <label class="icon" for="profilePicUpload2"><i
                                                class="fa-solid fa-camera cursor-pointer"></i></label>
                                        <span class="preview bg-img"
                                            data-background-image="{{ getImage(getFilePath('orgAward') . '/' . @$award->image, getFileSize('orgAward')) }}"></span>
                                    </label>
                                    <span class="thumb-upload__text mt-1"> @lang('Image will be resized into') ( <span
                                            class="text--danger">{{ getFileSize('orgAward') }}</span> )
                                    </span>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="form-label">@lang('Title')</label>
                                <div class="input-group input--group">
                                    <span class="input-group-text"><i class="las la-heading"></i></span>
                                    <input class="form-control form--control" name="title" type="text" required>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="form-label">@lang('Contribution')</label>

                                <textarea class="form-control form--control" name="contribution" required></textarea>
                            </div>
                            <div class="form-group">
                                <label class="form-label">@lang('Awarded By')</label>

                                <div class="input-group input--group">
                                    <span class="input-group-text"><i class="fa-solid fa-user"></i></span>
                                    <input class="form-control form--control" name="institute" type="text" required>
                                </div>
                            </div>
                            <button class="btn btn--base w-100" type="submit">@lang('Submit')</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endif

    <x-confirmation-modal :isFrontend="true" />

@endsection

@push('style')
    <style>
        .table-responsive {
            min-height: 250px;
            background: transparent
        }

        .custom--card .card-body {
            padding: .5rem;
        }

        .avatar {
            width: 35px;
            height: 35px;
        }

        .avatar-preview .profilePicPreview {
            border-radius: 5px !important;
        }

        .custom--card .card-header {
            border-bottom: transparent;
        }
    </style>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";
            //update
            let awardModal = $("#awardModal");
            let form = awardModal.find("form");
            const action = form[0] ? form[0].action : null;
            $(document).on("click", ".awardModalBtn", function() {
                let data = $(this).data();
                let resource = data.resource ?? null;
                awardModal.find(".modal-title").text(`${data.modal_title}`);

                if (!resource) {
                    form[0].reset();
                    form[0].action = `${action}`;
                }
                if (resource) {
                    form[0].action = `${action}/${resource.id}`;
                    // If form has image
                    if (resource.image_with_path) {
                        awardModal
                            .find(".profilePicPreview")
                            .css("background-image", `url(${resource.image_with_path})`);
                    }
                    awardModal.find("[name='title']").val(resource.title);
                    awardModal.find("[name='institute']").val(resource.institute);
                    awardModal.find("[name='contribution']").val(resource.contribution);
                }
                awardModal.modal("show");
            });


            //image preview
            function proPicURL(input) {
                if (input.files && input.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        var preview = $(input).parents('.profile-thumb').find('.profilePicPreview');
                        $(preview).css('background-image', 'url(' + e.target.result + ')');
                        $(preview).addClass('has-image');
                        $(preview).hide();
                        $(preview).fadeIn(650);
                    }
                    reader.readAsDataURL(input.files[0]);
                }
            }
            $(".profilePicUpload").on('change', function() {
                proPicURL(this);
            });

            $('#awardModal').on('hidden.bs.modal', function() {
                $(this).find('.preview').css('background-image', `url('{{ $awardImage }}')`)
            })


        })(jQuery);
    </script>
@endpush
