@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="d-xl-none position-relative z-1 mb-2">
        <button class="btn btn-outline--base" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight" aria-controls="offcanvasRight">
            <span class="icon"><i class="fa-solid fa-bars"></i></span>
            <span class="text">@lang('Menu')</span>
        </button>
    </div>
    <div class="container">
        <div class="card custom--card">
            @include($activeTemplate . 'partials.organizational_header')
            <div class="card-body p-0">
                @if ($org)
                    <div class="flex-between gap-2 p-3 py-md-4">
                        <h5 class="my-2">
                            @lang('Organization'): {{ __($org->name) }}
                        </h5>
                        <button class="btn btn-sm btn--base donorModalBtn" data-modal_title="@lang('Add New Award')">
                            <i class="las la-plus"></i>@lang('New')
                        </button>
                    </div>
                @endif
                @if ($org)
                    @if (!blank($donors))
                        <div class="table custom--table table--responsive--md has-table-card">
                            <table class="table table--responsive--md">
                                <thead>
                                    <tr>
                                        <th>@lang('Donor')</th>
                                        <th>@lang('Name')</th>
                                        <th>@lang('Details')</th>
                                        <th class="dp-action">@lang('Action')</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($donors as $donor)
                                        <tr>
                                            <td>
                                                <div class="avatar">
                                                    <img class="avatar__img" src="{{ getImage(getFilePath('orgDonor') . '/' . @$donor->image, getFileSize('orgDonor')) }}">
                                                </div>
                                            </td>
                                            <td>
                                                {{ __($donor->name) }}
                                            </td>
                                            <td>
                                                {{ strLimit(__($donor->details), 50) }}
                                            </td>

                                            @php
                                                $donor->image_with_path = getImage(getFilePath('orgDonor') . '/' . $donor->image, getFileSize('orgDonor'));
                                            @endphp
                                            <td>
                                                <div class="btn-group">
                                                    <button data-bs-toggle="dropdown" aria-expanded="false" class="action-group-link action-icon-btn">
                                                        <i class="fa-solid fa-list"></i>
                                                    </button>
                                                    <ul class="dropdown-menu dropdown--menu px-2">
                                                        <li>
                                                            <button class="dropdown-item donorModalBtn text--base" data-modal_title="@lang('Update Award')" data-resource="{{ $donor }}">
                                                                <i class="las la-pen"></i> @lang('Edit')
                                                            </button>
                                                        </li>
                                                        <li>
                                                            <button class="dropdown-item confirmationBtn text--danger" data-question="@lang('Are you certain about deleting this award? Once confirmed, this action can\'t be undone!')" data-action="{{ route('user.org.donor.delete', $donor->id) }}">
                                                                <i class="las la-trash"></i> @lang('Delete')
                                                            </button>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        @if ($donors->hasPages())
                            <div class="pt-3">
                                {{ paginateLinks($donors) }}
                            </div>
                        @endif
                    @else
                        <div class="mb-3">
                            @include($activeTemplate . 'partials.empty', [
                                'message' => 'No donors found.',
                            ])
                        </div>
                    @endif
                @else
                    <div class="card custom--card  dashboard-sidebar overflow-y-auto">
                        <div class="empty-files">
                            <h5 class="text-center">@lang('You have to create an organization first to add donors')</h5>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>

    @php
        $donorImage = getImage(getFilePath('orgDonor'), getFileSize('orgDonor'));
    @endphp

    <div class="modal custom--modal" id="donorModal">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <form action="{{ route('user.org.donor') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-header">
                        <h5 class="mb-0 modal-title"></h5>
                        <button class="btn-close" data-bs-dismiss="modal" type="button"></button>
                    </div>
                    <div class="modal-body p-4">
                        <div class="row">
                            <div class="col-lg-4">
                                <div class="form-group">

                                    <label class="form-label">@lang('Donor Photo')</label>
                                    <div class="thumb-upload profile-thumb mx-auto">
                                        <label for="profilePicUpload1" class="thumb-upload__label">
                                            <input type="file" class="d-none profilePicUpload" id="profilePicUpload1" name="image" accept=".png, .jpg, .jpeg">
                                            <label class="icon" for="profilePicUpload1"><i class="fa-solid fa-camera cursor-pointer"></i></label>
                                            <span class="preview bg-img" data-background-image=""></span>
                                        </label>
                                        <span class="thumb-upload__text mt-1">@lang('Size') ( <span class="text--danger">{{ getFileSize('orgDonor') }}</span> )
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-8">
                                <div class="form-group">
                                    <label class="form-label">@lang('Name')</label>
                                    <div class="input-group input--group">
                                        <span class="input-group-text"><i class="fa-solid fa-user-alt"></i></span>
                                        <input class="form-control form--control" name="name" type="text" required>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="form-label">@lang('Details')</label>
                                    <textarea class="form-control form--control" name="details" required></textarea>
                                </div>
                            </div>
                        </div>
                        <button class="btn btn--base w-100" type="submit">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <x-confirmation-modal :isFrontend="true" />
@endsection

@push('style')
    <style>
        .table-responsive {
            min-height: 250px;
            background: transparent
        }

        .custom--card .card-body {
            padding: .5rem;
        }

        .avatar {
            width: 35px;
            height: 35px;
        }

        .avatar-preview .profilePicPreview {
            border-radius: 5px !important;
        }

        .custom--card .card-header {
            border-bottom: transparent;
        }
    </style>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";

            //delete-modal
            $(document).on('click', '.deleteBtn', function() {
                let action = $(this).data('action');
                var modal = $("#confirmDeleteModal");
                let form = modal.find("form");
                form.attr('action', action);
                modal.modal('show');
            });

            //update
            let donorModal = $("#donorModal");
            let form = donorModal.find("form");
            const action = form[0] ? form[0].action : null;
            $(document).on("click", ".donorModalBtn", function() {
                let data = $(this).data();
                let resource = data.resource ?? null;
                donorModal.find(".modal-title").text(`${data.modal_title}`);

                if (!resource) {
                    form[0].reset();
                    form[0].action = `${action}`;
                }
                if (resource) {
                    form[0].action = `${action}/${resource.id}`;
                    // If form has image
                    if (resource.image_with_path) {
                        donorModal
                            .find(".profilePicPreview")
                            .css("background-image", `url(${resource.image_with_path})`);
                    }
                    donorModal.find("[name='name']").val(resource.name);
                    donorModal.find("[name='details']").val(resource.details);
                }
                donorModal.modal("show");
            });


            //image preview
            function proPicURL(input) {
                if (input.files && input.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        var preview = $(input).parents('.profile-thumb').find('.profilePicPreview');
                        $(preview).css('background-image', 'url(' + e.target.result + ')');
                        $(preview).addClass('has-image');
                        $(preview).hide();
                        $(preview).fadeIn(650);
                    }
                    reader.readAsDataURL(input.files[0]);
                }
            }
            $(".profilePicUpload").on('change', function() {
                proPicURL(this);
            });

            $('#donorModal').on('hidden.bs.modal', function() {
                $(this).find('.profilePicPreview').css('background-image', `url('{{ $donorImage }}')`)
            })

        })(jQuery);
    </script>
@endpush
