@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="d-xl-none position-relative z-1 mb-2">
        <button class="btn btn-outline--base" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight" aria-controls="offcanvasRight">
            <span class="icon"><i class="fa-solid fa-bars"></i></span>
            <span class="text">@lang('Menu')</span>
        </button>
    </div>
    <div class="container">
        <div class="card custom--card">
            @include($activeTemplate . 'partials.organizational_header')

            @if ($org)
                <div class="flex-between gap-2 p-3 py-md-4">
                    <h5 class="my-2">
                        @lang('Organization'):
                        @if ($org)
                            {{ __($org->name) }}
                        @endif
                    </h5>
                    <button class="btn btn-sm btn--base updateModalBtn" data-modal_title="@lang('New Update')">
                        <i class="las la-plus"></i>@lang('New Update')
                    </button>
                </div>
            @endif
            <div class="card-body p-0">
                @if ($org)
                    @if (!blank($updates))
                        <div class="table custom--table table--responsive--md has-table-card">
                            <table class="table table--responsive--md">
                                <thead>
                                    <tr>
                                        <th>@lang('S.N.')</th>
                                        <th>@lang('Updated at')</th>
                                        <th>@lang('Details')</th>
                                        <th class="dp-action">@lang('Action')</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($updates as $update)
                                        <tr>
                                            <td>
                                                {{ $updates->firstItem() + $loop->index }}
                                            </td>
                                            <td>
                                                {{ showDateTime($update->date, 'Y,F d') }}
                                            </td>
                                            <td>
                                                {{ strLimit(__($update->updation), 50) }}
                                            </td>

                                            <td>
                                                <div class="btn-group">
                                                    <button data-bs-toggle="dropdown" aria-expanded="false" class="action-group-link action-icon-btn">
                                                        <i class="fa-solid fa-list"></i>
                                                    </button>
                                                    <ul class="dropdown-menu dropdown--menu px-2">
                                                        <li>
                                                            <button class="dropdown-item updateModalBtn text--base" data-modal_title="@lang('Edit Updation')" data-resource="{{ $update }}" data-date="{{ showDateTime($update->date, 'Y-m-d') }}">
                                                                <i class="las la-pen"></i> @lang('Edit')
                                                            </button>
                                                        </li>
                                                        <li>
                                                            <button class="dropdown-item confirmationBtn text--danger" data-question="@lang('Are you certain about deleting this updation? Once confirmed, this action can\'t be undone!')" data-action="{{ route('user.org.update.delete', $update->id) }}">
                                                                <i class="las la-trash"></i> @lang('Delete')
                                                            </button>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        @if ($updates->hasPages())
                            <div class="pt-3">
                                {{ paginateLinks($updates) }}
                            </div>
                        @endif
                    @else
                        <div class="mb-3">
                            @include($activeTemplate . 'partials.empty', [
                                'message' => 'No update available',
                            ])
                        </div>
                    @endif
                @else
                    <div class="card custom--card  dashboard-sidebar overflow-y-auto">
                        <div class="empty-files">
                            <h5 class="text-center">@lang('You have to create an organization first to add update')</h5>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
    <div class="modal custom--modal" id="updateModal">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <form action="{{ route('user.org.update') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-header">
                        <h5 class="mb-0 modal-title"></h5>
                        <button class="btn-close" data-bs-dismiss="modal" type="button"></button>
                    </div>
                    <div class="modal-body p-4">
                        <div class="form-group">
                            <label class="form-label">@lang('Update at')</label>
                            <div class="input--group input-group">
                                <span class="input-group-text"><i class="fa-solid fa-calendar-alt"></i></span>
                                <input class="datepicker-here1 form-control form--control" name="date" data-range="true" data-language="en" data-position='bottom left' type="text" value="{{ old('date') }}" autocomplete="off" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="form-label">@lang('Updation')</label>
                            <textarea class="form-control form--control" name="updation" required></textarea>
                        </div>
                        <button class="btn btn--base w-100" type="submit">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <x-confirmation-modal :isFrontend="true" />

    </div>
@endsection

@push('style-lib')
    <link href="{{ asset($activeTemplateTrue . 'css/datepicker.min.css') }}" rel="stylesheet">
@endpush

@push('script-lib')
    <script src="{{ asset($activeTemplateTrue . 'js/datepicker.min.js') }}"></script>
    <script src="{{ asset($activeTemplateTrue . 'js/datepicker.en.js') }}"></script>
@endpush

@push('style')
    <style>
        .datepicker {
            z-index: 9999
        }

        .table-responsive {
            min-height: 250px;
            background: transparent
        }

        .custom--card .card-body {
            padding: .5rem;
        }

        .custom--card .card-header {
            border-bottom: transparent;
        }
    </style>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";

            $('.datepicker-here1').on('keyup keypress keydown input', function(event) {
                event.preventDefault();
            });

            $('.datepicker-here1').datepicker('destroy').datepicker({
                minDate: new Date(),
                range: false,
                autoClose: true,
                dateFormat: 'yyyy-mm-dd',
                onSelect: function(formattedDate, date, inst) {
                    $('.datepicker-here1').val(formattedDate);
                }
            });

            //delete-modal
            $(document).on('click', '.deleteBtn', function() {
                let action = $(this).data('action');
                var modal = $("#confirmDeleteModal");
                let form = modal.find("form");
                form.attr('action', action);
                modal.modal('show');
            });

            //update
            let updateModal = $("#updateModal");
            let form = updateModal.find("form");
            const action = form[0] ? form[0].action : null;
            $(document).on("click", ".updateModalBtn", function() {
                let data = $(this).data();

                let resource = data.resource ?? null;
                updateModal.find(".modal-title").text(`${data.modal_title}`);

                if (!resource) {
                    form[0].reset();
                    form[0].action = `${action}`;
                }
                if (resource) {
                    form[0].action = `${action}/${resource.id}`;
                    updateModal.find("[name='date']").val(data.date);
                    updateModal.find("[name='updation']").val(resource.updation);
                }
                updateModal.modal("show");
            });

        })(jQuery);
    </script>
@endpush
